/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.shop;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.shop.Shop;
import com.petrolpark.team.data.ITeamDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TeamShopsData
extends HashMap<Shop, TeamShop> {
    public TeamShop getOrCreate(Shop shop) {
        return this.computeIfAbsent(shop, s -> this.defaultEntry());
    }

    public void grantXP(Shop shop, int amount) {
        this.getOrCreate((Shop)shop).xp += amount;
    }

    public Component getName(Shop shop) {
        String customName = this.getOrCreate((Shop)shop).customName;
        if (customName.isEmpty()) {
            return shop.getName();
        }
        return Component.m_237113_((String)customName);
    }

    protected TeamShop defaultEntry() {
        return new TeamShop("", 0);
    }

    protected class TeamShop {
        public int xp;
        public String customName;

        public TeamShop(String customName, int xp) {
            this.customName = customName;
            this.xp = xp;
        }
    }

    public static class Type
    implements ITeamDataType<TeamShopsData> {
        @Override
        public TeamShopsData getBlankInstance() {
            return new TeamShopsData();
        }

        @Override
        public boolean isBlank(TeamShopsData data) {
            return data.isEmpty();
        }

        @Override
        public TeamShopsData load(Level level, CompoundTag tag) {
            Registry registry = level.m_9598_().m_175515_(PetrolparkRegistries.Keys.SHOP);
            TeamShopsData data = this.getBlankInstance();
            for (String key : tag.m_128431_()) {
                Shop shop = (Shop)registry.m_7745_(new ResourceLocation(key));
                if (shop == null || !tag.m_128425_(key, 10)) continue;
                CompoundTag shopTag = tag.m_128469_(key);
                String customName = shopTag.m_128461_("Name");
                int xp = shopTag.m_128451_("XP");
                if (xp == 0 || customName.isEmpty()) continue;
                TeamShopsData teamShopsData = data;
                Objects.requireNonNull(teamShopsData);
                data.put(shop, teamShopsData.new TeamShop(customName, xp));
            }
            return data;
        }

        @Override
        public CompoundTag save(Level level, TeamShopsData data) {
            Registry registry = level.m_9598_().m_175515_(PetrolparkRegistries.Keys.SHOP);
            CompoundTag tag = new CompoundTag();
            for (Map.Entry entry : data.entrySet()) {
                CompoundTag shopTag = new CompoundTag();
                if (!((TeamShop)entry.getValue()).customName.isEmpty()) {
                    shopTag.m_128359_("Name", ((TeamShop)entry.getValue()).customName);
                }
                if (((TeamShop)entry.getValue()).xp != 0) {
                    shopTag.m_128405_("XP", ((TeamShop)entry.getValue()).xp);
                }
                tag.m_128365_(registry.m_7981_((Object)((Shop)entry.getKey())).toString(), (Tag)shopTag);
            }
            return tag;
        }
    }
}

