/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.PetrolparkItemAttributes;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.IntrinsicContaminants;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.util.NBTHelper;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RequiresCreate
public class HasContaminantItemAttribute
implements ItemAttribute {
    @Nullable
    private Contaminant contaminant;

    public HasContaminantItemAttribute(@Nullable Contaminant contaminant) {
        this.contaminant = contaminant;
    }

    public boolean appliesTo(ItemStack stack, Level world) {
        return ItemContamination.get(stack).has(this.contaminant);
    }

    public ItemAttributeType getType() {
        return PetrolparkItemAttributes.HAS_CONTAMINANT;
    }

    public void save(CompoundTag nbt) {
        if (this.contaminant == null) {
            return;
        }
        NBTHelper.writeRegistryObject(nbt, "Contaminant", PetrolparkRegistries.Keys.CONTAMINANT, this.contaminant);
    }

    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("Contaminant")) {
            this.contaminant = NBTHelper.readRegistryObject(nbt, "Contaminant", PetrolparkRegistries.Keys.CONTAMINANT);
        }
    }

    public String getTranslationKey() {
        return "has_contaminant";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.contaminant.getName()};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new HasContaminantItemAttribute(null);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            IContamination<?, ?> contamination = ItemContamination.get(stack);
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>(contamination.streamAllContaminants().map(HasContaminantItemAttribute::new).map(ItemAttribute.class::cast).toList());
            IntrinsicContaminants.getShownIfAbsent(contamination).forEach(c -> list.add(new HasContaminantItemAttribute((Contaminant)c)));
            return list;
        }
    }
}

