/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.item.directional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.item.directional.IDirectionalOnBelt;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RequiresCreate
public class DirectionalTransportedItemStack
extends TransportedItemStack {
    @Nullable
    protected Rotation rotation;

    public DirectionalTransportedItemStack(ItemStack stack) {
        super(stack);
        Item item = stack.m_41720_();
        if (item instanceof IDirectionalOnBelt) {
            IDirectionalOnBelt item2 = (IDirectionalOnBelt)item;
            v0 = item2.rotationForPlacement(stack);
        } else {
            v0 = this.rotation = null;
        }
        if (this.rotation == null) {
            this.rotation = Rotation.NONE;
        }
        this.refreshAngle();
    }

    public float getTargetSideOffset() {
        return 0.0f;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void rotate(Rotation appliedRotation) {
        this.rotation = appliedRotation.m_55952_(this.rotation);
        this.refreshAngle();
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.refreshAngle();
    }

    public void refreshAngle() {
        if (this.rotation != null) {
            this.angle = this.getTargetAngle();
        }
    }

    public final int getTargetAngle() {
        if (this.rotation == null) {
            return 0;
        }
        switch (this.rotation) {
            case NONE: {
                return 180;
            }
            case CLOCKWISE_90: {
                return 90;
            }
            case CLOCKWISE_180: {
                return 0;
            }
            case COUNTERCLOCKWISE_90: {
                return 270;
            }
        }
        return 0;
    }

    public TransportedItemStack getSimilar() {
        return DirectionalTransportedItemStack.copy(this);
    }

    public TransportedItemStack copy() {
        return DirectionalTransportedItemStack.copy(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean overrideRender(ItemRenderer itemRenderer, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        return false;
    }

    public static DirectionalTransportedItemStack copy(TransportedItemStack transportedItemStack) {
        return DirectionalTransportedItemStack.copy(transportedItemStack, DirectionalTransportedItemStack::new);
    }

    public static <DTIS extends DirectionalTransportedItemStack> DTIS copy(TransportedItemStack transportedItemStack, Function<ItemStack, DTIS> dtisFactory) {
        DirectionalTransportedItemStack copy = (DirectionalTransportedItemStack)((Object)dtisFactory.apply(transportedItemStack.stack.m_41777_()));
        copy.beltPosition = transportedItemStack.beltPosition;
        copy.insertedAt = transportedItemStack.insertedAt;
        copy.insertedFrom = transportedItemStack.insertedFrom;
        copy.prevBeltPosition = transportedItemStack.prevBeltPosition;
        copy.prevSideOffset = transportedItemStack.prevSideOffset;
        copy.processedBy = transportedItemStack.processedBy;
        copy.processingTime = transportedItemStack.processingTime;
        if (transportedItemStack instanceof DirectionalTransportedItemStack) {
            DirectionalTransportedItemStack directionalStack = (DirectionalTransportedItemStack)transportedItemStack;
            if (directionalStack.rotation != null) {
                copy.rotation = directionalStack.rotation;
            }
            copy.refreshAngle();
        }
        return (DTIS)((Object)copy);
    }

    public static DirectionalTransportedItemStack copyFully(TransportedItemStack transportedItemStack) {
        return DirectionalTransportedItemStack.copyFully(transportedItemStack, DirectionalTransportedItemStack::new);
    }

    public static <DTIS extends DirectionalTransportedItemStack> DTIS copyFully(TransportedItemStack transportedItemStack, Function<ItemStack, DTIS> dtisFactory) {
        DTIS copy = DirectionalTransportedItemStack.copy(transportedItemStack, dtisFactory);
        ((DirectionalTransportedItemStack)((Object)copy)).locked = transportedItemStack.locked;
        ((DirectionalTransportedItemStack)((Object)copy)).lockedExternally = transportedItemStack.lockedExternally;
        return copy;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.rotation != null) {
            nbt.m_128405_("Rotation", this.rotation.ordinal());
        }
        return nbt;
    }
}

