/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.block.entity.behaviour;

import com.petrolpark.RequiresCreate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@RequiresCreate
public abstract class AbstractRememberPlacerBehaviour
extends BlockEntityBehaviour {
    private UUID playerUUID;

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            AbstractRememberPlacerBehaviour.setPlacedBy(player.m_9236_(), event.getPos(), player);
        }
    }

    public AbstractRememberPlacerBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public abstract boolean shouldRememberPlacer(Player var1);

    @Nullable
    public Player getPlayer() {
        if (this.playerUUID == null) {
            return null;
        }
        return this.getWorld().m_46003_(this.playerUUID);
    }

    public void setPlayer(UUID uuid) {
        Player player = this.getWorld().m_46003_(uuid);
        if (player == null) {
            return;
        }
        this.playerUUID = uuid;
        this.blockEntity.m_6596_();
    }

    public static void setPlacedBy(Level level, BlockPos pos, LivingEntity placer) {
        BlockEntity be;
        if (placer == null || !(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        try {
            be = level.m_7702_(pos);
        }
        catch (ConcurrentModificationException e) {
            be = null;
        }
        if (be == null || !(be instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)be;
        AbstractRememberPlacerBehaviour.setPlacedBy(sbe, player);
    }

    public static void setPlacedBy(SmartBlockEntity be, Player player) {
        if (player == null) {
            return;
        }
        for (BlockEntityBehaviour behaviour : be.getAllBehaviours()) {
            AbstractRememberPlacerBehaviour arpb;
            if (!(behaviour instanceof AbstractRememberPlacerBehaviour) || !(arpb = (AbstractRememberPlacerBehaviour)behaviour).shouldRememberPlacer(player)) continue;
            arpb.setPlayer(player.m_20148_());
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128441_("Owner")) {
            this.playerUUID = nbt.m_128342_("Owner");
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        Player player = this.getPlayer();
        if (!nbt.m_128441_("Owner") && player != null && this.shouldRememberPlacer(player)) {
            nbt.m_128362_("Owner", this.playerUUID);
        }
    }
}

