/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.badge;

import com.petrolpark.badge.BadgeItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class BadgeDuplicationRecipe
extends CustomRecipe {
    public static final RecipeSerializer<BadgeDuplicationRecipe> BADGE_DUPLICATION = new SimpleCraftingRecipeSerializer(BadgeDuplicationRecipe::new);

    public BadgeDuplicationRecipe(ResourceLocation rl, CraftingBookCategory category) {
        super(rl, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack badge = null;
        ItemStack duplicationStack = null;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() instanceof BadgeItem && badge == null) {
                badge = stack;
                continue;
            }
            if (duplicationStack == null) {
                duplicationStack = stack;
                continue;
            }
            return false;
        }
        if (badge == null) {
            return false;
        }
        Ingredient duplicationIngredient = ((BadgeItem)badge.m_41720_()).badge.get().getDuplicationIngredient();
        return duplicationIngredient != null && duplicationIngredient.test(duplicationStack);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (!(stack.m_41720_() instanceof BadgeItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return BADGE_DUPLICATION;
    }
}

