/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.mojang.logging.LogUtils;
import com.petrolpark.PetrolparkClient;
import com.petrolpark.PetrolparkConfig;
import com.petrolpark.PetrolparkItemDisplayContexts;
import com.petrolpark.PetrolparkItems;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.badge.Badges;
import com.petrolpark.compat.CompatMods;
import com.petrolpark.compat.create.Create;
import com.petrolpark.compat.curios.Curios;
import com.petrolpark.compat.jei.category.ITickableCategory;
import com.petrolpark.data.loot.PetrolparkGlobalLootModifierSerializers;
import com.petrolpark.data.loot.PetrolparkLootConditionTypes;
import com.petrolpark.data.loot.PetrolparkLootEntityNumberProviderTypes;
import com.petrolpark.data.loot.PetrolparkLootItemStackNumberProviderTypes;
import com.petrolpark.data.loot.PetrolparkLootNumberProviderTypes;
import com.petrolpark.data.loot.PetrolparkLootTeamNumberProviders;
import com.petrolpark.data.reward.RewardGeneratorTypes;
import com.petrolpark.data.reward.RewardTypes;
import com.petrolpark.item.decay.DecayingItemHandler;
import com.petrolpark.mobeffects.PetrolparkMobEffects;
import com.petrolpark.network.PetrolparkMessages;
import com.petrolpark.recipe.IPetrolparkRecipeTypes;
import com.petrolpark.recipe.ingredient.modifier.IngredientModifierTypes;
import com.petrolpark.recipe.ingredient.randomizer.IngredientRandomizerTypes;
import com.petrolpark.registrate.PetrolparkRegistrate;
import com.petrolpark.team.TeamTypes;
import com.petrolpark.team.data.TeamDataTypes;
import com.petrolpark.team.scoreboard.ScoreboardTeamManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="petrolpark")
public class Petrolpark {
    public static final String MOD_ID = "petrolpark";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final PetrolparkRegistrate REGISTRATE = new PetrolparkRegistrate("petrolpark");
    public static final PetrolparkRegistrate DESTROY_REGISTRATE = CompatMods.DESTROY.registrate();
    public static final ThreadLocal<DecayingItemHandler> DECAYING_ITEM_HANDLER = ThreadLocal.withInitial(() -> DecayingItemHandler.DUMMY);
    public static final ScoreboardTeamManager SCOREBOARD_TEAMS = new ScoreboardTeamManager();

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public Petrolpark() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        DESTROY_REGISTRATE.registerEventListeners(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)PetrolparkConfig.serverSpec);
        PetrolparkRegistries.register();
        Badges.register();
        IPetrolparkRecipeTypes.register(modEventBus);
        PetrolparkItems.register();
        PetrolparkMobEffects.register();
        TeamTypes.register();
        TeamDataTypes.register();
        PetrolparkLootConditionTypes.register();
        PetrolparkLootNumberProviderTypes.register();
        PetrolparkLootItemStackNumberProviderTypes.register();
        PetrolparkLootEntityNumberProviderTypes.register();
        PetrolparkLootTeamNumberProviders.register();
        PetrolparkGlobalLootModifierSerializers.register();
        RewardGeneratorTypes.register();
        RewardTypes.register();
        IngredientModifierTypes.register();
        IngredientRandomizerTypes.register();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PetrolparkClient.clientCtor(modEventBus, forgeEventBus));
        forgeEventBus.register((Object)this);
        modEventBus.addListener(this::init);
        if (CompatMods.JEI.isLoading()) {
            forgeEventBus.register(ITickableCategory.ClientEvents.class);
        }
        CompatMods.CREATE.executeIfInstalled(() -> () -> Create.ctor(modEventBus, forgeEventBus));
        CompatMods.CURIOS.executeIfInstalled(() -> () -> Curios.ctor(modEventBus, forgeEventBus));
    }

    private void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PetrolparkMessages.register());
    }

    static {
        PetrolparkItemDisplayContexts.register();
    }
}

