/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.differential;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.petrolsparts.PetrolsPartsPartialModels;
import com.petrolpark.petrolsparts.content.differential.DifferentialBlockEntity;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DifferentialRenderer
extends KineticBlockEntityRenderer<DifferentialBlockEntity> {
    public DifferentialRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(DifferentialBlockEntity differential, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!differential.m_58898_()) {
            return;
        }
        BlockState state = this.getRenderedBlockState((KineticBlockEntity)differential);
        Direction face = DirectionalRotatedPillarKineticBlock.getDirection(state);
        Direction.Axis axis = face.m_122434_();
        VertexConsumer vbSolid = buffer.m_6299_(RenderType.m_110451_());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)differential.m_58904_());
        float ringGearOffset = (float)Math.PI * DifferentialRenderer.getRotationOffsetForPosition((KineticBlockEntity)differential, (BlockPos)differential.m_58899_(), (Direction.Axis)axis) / 180.0f;
        float ringGearAngle = (time * differential.getSpeed() * 3.0f / 10.0f + ringGearOffset) % 360.0f / 180.0f * (float)Math.PI;
        BlockPos inputPos = differential.m_58899_().m_121945_(face);
        BlockPos controlPos = differential.m_58899_().m_121945_(face.m_122424_());
        BlockEntity inputBE = differential.m_58904_().m_7702_(inputPos);
        BlockEntity controlBE = differential.m_58904_().m_7702_(controlPos);
        float inputShaftOffset = (float)Math.PI * BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)inputPos) / 180.0f;
        float controlShaftOffset = (float)Math.PI * BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)controlPos) / 180.0f;
        float inputCogAngle = 0.0f;
        float controlCogAngle = 0.0f;
        if (differential.propagatesToMe(inputPos, face.m_122424_()) && inputBE instanceof KineticBlockEntity) {
            KineticBlockEntity inputKBE = (KineticBlockEntity)inputBE;
            inputCogAngle = time * differential.getPropagatedSpeed(inputKBE, face) * 3.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        }
        if (differential.propagatesToMe(controlPos, face) && controlBE instanceof KineticBlockEntity) {
            KineticBlockEntity controlKBE = (KineticBlockEntity)controlBE;
            controlCogAngle = time * differential.getPropagatedSpeed(controlKBE, face.m_122424_()) * 3.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        }
        SuperByteBuffer ringGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_RING_GEAR, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)ringGear, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(ringGearAngle + ringGearOffset), (int)light);
        ringGear.renderInto(ms, vbSolid);
        SuperByteBuffer eastGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_EAST_GEAR, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)eastGear, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(ringGearAngle + ringGearOffset), (int)light);
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)eastGear, (KineticBlockEntity)differential, (Direction.Axis)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X), (float)((controlCogAngle - inputCogAngle) / 2.0f * (float)(axis == Direction.Axis.Z ? -1 : 1)), (int)light);
        eastGear.renderInto(ms, vbSolid);
        SuperByteBuffer westGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_WEST_GEAR, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)westGear, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(ringGearAngle + ringGearOffset), (int)light);
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)westGear, (KineticBlockEntity)differential, (Direction.Axis)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X), (float)((inputCogAngle - controlCogAngle) / 2.0f * (float)(axis == Direction.Axis.Z ? -1 : 1)), (int)light);
        westGear.renderInto(ms, vbSolid);
        SuperByteBuffer topGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_CONTROL_GEAR, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)topGear, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(controlCogAngle + ringGearOffset), (int)light);
        topGear.renderInto(ms, vbSolid);
        SuperByteBuffer topShaft = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_CONTROL_SHAFT, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)topShaft, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(controlCogAngle + controlShaftOffset), (int)light);
        topShaft.renderInto(ms, vbSolid);
        SuperByteBuffer bottomGear = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_INPUT_GEAR, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)bottomGear, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(inputCogAngle + ringGearOffset), (int)light);
        bottomGear.renderInto(ms, vbSolid);
        SuperByteBuffer bottomShaft = CachedBuffers.partialDirectional((PartialModel)PetrolsPartsPartialModels.DIFFERENTIAL_INPUT_SHAFT, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face));
        DifferentialRenderer.kineticRotationTransform((SuperByteBuffer)bottomShaft, (KineticBlockEntity)differential, (Direction.Axis)axis, (float)(inputCogAngle + inputShaftOffset), (int)light);
        bottomShaft.renderInto(ms, vbSolid);
    }
}

