/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.molten_metals.fluids;

import com.ordana.molten_metals.MoltenMetals;
import com.ordana.molten_metals.fluids.MoltenMetalRenderer;
import com.ordana.molten_metals.reg.ModFluids;
import com.ordana.molten_metals.reg.ModItems;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.mehvahdjukaar.moonlight.api.fluids.ModFlowingFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MoltenMetalFluid
extends ModFlowingFluid {
    public MoltenMetalFluid(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
        super(properties, block);
    }

    public ModFluidRenderProperties createRenderProperties() {
        return new MoltenMetalRenderer(MoltenMetals.res("block/texture"), MoltenMetals.res("block/texture_flowing"), -1, MoltenMetals.res("block/texture_flowing"), MoltenMetals.res("block/texture_flowing"), new Vec3(133.0, 0.0, 0.0));
    }

    @NotNull
    public Fluid m_5615_() {
        return (Fluid)ModFluids.FLOWING_MOLTEN_BRASS.get();
    }

    @NotNull
    public Fluid m_5613_() {
        return (Fluid)ModFluids.MOLTEN_BRASS.get();
    }

    @NotNull
    public Item m_6859_() {
        return ModItems.MOLTEN_BRASS_BUCKET.get();
    }

    @NotNull
    public Optional<SoundEvent> m_142520_() {
        return Optional.of(SoundEvents.f_11783_);
    }

    protected ParticleOptions m_7792_() {
        return ParticleTypes.f_123800_;
    }

    public void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos blockPos = pos.m_7494_();
        if (level.m_8055_(blockPos).m_60795_() && !level.m_8055_(blockPos).m_60804_((BlockGetter)level, blockPos)) {
            boolean raining = level.m_46758_(pos.m_7494_());
            if (random.m_188503_(100) == 0) {
                double d = (double)pos.m_123341_() + random.m_188500_();
                double e = (double)pos.m_123342_() + 1.0;
                double f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)(raining ? ParticleTypes.f_123762_ : ParticleTypes.f_123756_), d, e, f, 0.0, 0.0, 0.0);
                level.m_7785_(d, e, f, raining ? SoundEvents.f_12031_ : SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
            if (random.m_188503_(200) == 0) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    protected int m_6719_(@NotNull LevelReader level) {
        return 2;
    }

    protected int m_6713_(@NotNull LevelReader level) {
        return 2;
    }

    public int m_6718_(@NotNull LevelReader level) {
        return 20;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public boolean m_7444_(@NotNull FluidState state) {
        return false;
    }

    public int m_7430_(@NotNull FluidState state) {
        return 0;
    }

    protected boolean m_6685_() {
        return true;
    }

    public void m_213812_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        block7: {
            if (!level.m_46469_().m_46207_(GameRules.f_46131_)) break block7;
            int i = random.m_188503_(3);
            if (i > 0) {
                BlockPos blockPos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.m_46749_(blockPos = blockPos.m_7918_(random.m_188503_(3) - 1, 1, random.m_188503_(3) - 1))) {
                        return;
                    }
                    BlockState blockState = level.m_8055_(blockPos);
                    if (blockState.m_60795_()) {
                        if (!this.hasFlammableNeighbours((LevelReader)level, blockPos)) continue;
                        level.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos));
                        return;
                    }
                    if (!blockState.m_280555_()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockPos2 = pos.m_7918_(random.m_188503_(3) - 1, 0, random.m_188503_(3) - 1);
                    if (!level.m_46749_(blockPos2)) {
                        return;
                    }
                    if (!level.m_46859_(blockPos2.m_7494_()) || !this.isFlammable((LevelReader)level, blockPos2)) continue;
                    level.m_46597_(blockPos2.m_7494_(), BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos2));
                }
            }
        }
    }

    private boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isFlammable(level, pos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader level, BlockPos pos) {
        return (pos.m_123342_() < level.m_141937_() || pos.m_123342_() >= level.m_151558_() || level.m_46805_(pos)) && level.m_8055_(pos).m_278200_();
    }

    public static class Source
    extends MoltenMetalFluid {
        public Source(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
            super(properties, block);
        }

        @Override
        public int m_7430_(@NotNull FluidState state) {
            return 8;
        }

        @Override
        public boolean m_7444_(@NotNull FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends MoltenMetalFluid {
        public Flowing(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
            super(properties, block);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        @Override
        public int m_7430_(@NotNull FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        @Override
        public boolean m_7444_(@NotNull FluidState state) {
            return false;
        }
    }
}

