/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.registration.object.ItemObject;

public class MetalItemObject
extends ItemObject<Block> {
    private final Supplier<? extends Item> ingot;
    private final Supplier<? extends Item> nugget;
    private final TagKey<Block> blockTag;
    private final TagKey<Item> blockItemTag;
    private final TagKey<Item> ingotTag;
    private final TagKey<Item> nuggetTag;

    public MetalItemObject(String tagName, ItemObject<? extends Block> block, Supplier<? extends Item> ingot, Supplier<? extends Item> nugget) {
        super(block);
        this.ingot = ingot;
        this.nugget = nugget;
        this.blockTag = BlockTags.create((ResourceLocation)Mantle.commonResource("storage_blocks/" + tagName));
        this.blockItemTag = MetalItemObject.getTag("storage_blocks/" + tagName);
        this.ingotTag = MetalItemObject.getTag("ingots/" + tagName);
        this.nuggetTag = MetalItemObject.getTag("nuggets/" + tagName);
    }

    public Item getIngot() {
        return this.ingot.get();
    }

    public Item getNugget() {
        return this.nugget.get();
    }

    private static TagKey<Item> getTag(String name) {
        return ItemTags.create((ResourceLocation)Mantle.commonResource(name));
    }

    public TagKey<Block> getBlockTag() {
        return this.blockTag;
    }

    public TagKey<Item> getBlockItemTag() {
        return this.blockItemTag;
    }

    public TagKey<Item> getIngotTag() {
        return this.ingotTag;
    }

    public TagKey<Item> getNuggetTag() {
        return this.nuggetTag;
    }
}

