/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.function.TriFunction;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.util.JsonHelper;

public class EmptyFluidContainerTransfer
implements IFluidContainerTransfer.WithDirection {
    public static final ResourceLocation ID = Mantle.getResource("empty_item");
    private final Ingredient input;
    private final ItemOutput filled;
    protected final FluidOutput fluid;
    public static final JsonDeserializer<EmptyFluidContainerTransfer> DESERIALIZER = new Deserializer<EmptyFluidContainerTransfer>(EmptyFluidContainerTransfer::new);

    @Deprecated(forRemoval=true)
    public EmptyFluidContainerTransfer(Ingredient input, ItemOutput filled, FluidStack fluid) {
        this(input, filled, FluidOutput.fromStack(fluid));
    }

    @Override
    public void addRepresentativeItems(Consumer<Item> consumer) {
        for (ItemStack stack : this.input.m_43908_()) {
            consumer.accept(stack.m_41720_());
        }
    }

    @Override
    public boolean matches(ItemStack stack, FluidStack fluid) {
        return this.input.test(stack);
    }

    protected FluidStack getFluid(ItemStack stack) {
        return this.fluid.get();
    }

    @Override
    public IFluidContainerTransfer.TransferResult transfer(ItemStack stack, FluidStack fluid, IFluidHandler handler, IFluidContainerTransfer.TransferDirection direction) {
        int actual;
        if (!direction.canEmpty()) {
            return null;
        }
        FluidStack contained = this.getFluid(stack);
        int simulated = handler.fill(contained.copy(), IFluidHandler.FluidAction.SIMULATE);
        if (simulated == contained.getAmount() && (actual = handler.fill(contained.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
            if (actual != this.fluid.getAmount()) {
                Mantle.logger.error("Wrong amount filled from {}, expected {}, filled {}", (Object)BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()), (Object)this.fluid.getAmount(), (Object)actual);
            }
            return new IFluidContainerTransfer.TransferResult(this.filled.copy(), contained, false);
        }
        return null;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("input", this.input.m_43942_());
        json.add("filled", this.filled.serialize(false));
        json.add("fluid", FluidOutput.Loadable.REQUIRED.serialize(this.fluid));
        return json;
    }

    public EmptyFluidContainerTransfer(Ingredient input, ItemOutput filled, FluidOutput fluid) {
        this.input = input;
        this.filled = filled;
        this.fluid = fluid;
    }

    public record Deserializer<T extends EmptyFluidContainerTransfer>(TriFunction<Ingredient, ItemOutput, FluidOutput, T> factory) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            Ingredient input = Ingredient.m_43917_((JsonElement)JsonHelper.getElement(json, "input"));
            ItemOutput filled = (ItemOutput)ItemOutput.Loadable.REQUIRED_ITEM.getIfPresent(json, "filled");
            FluidOutput fluid = (FluidOutput)FluidOutput.Loadable.REQUIRED.getIfPresent(json, "fluid");
            return (T)((EmptyFluidContainerTransfer)this.factory.apply((Object)input, (Object)filled, (Object)fluid));
        }
    }
}

