/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class ItemElement
extends SizedBookElement {
    public static final int ITEM_SIZE_HARDCODED = 16;
    public static final long ITEM_SWITCH_TIME = 3000000000L;
    public NonNullList<ItemStack> itemCycle;
    public float scale;
    @Nullable
    public String action;
    public List<Component> tooltip;
    public long lastTime = Util.m_137569_();
    public int currentItem = 0;

    public ItemElement(int x, int y, float scale, Item item) {
        this(x, y, scale, new ItemStack((ItemLike)item));
    }

    public ItemElement(int x, int y, float scale, Block item) {
        this(x, y, scale, new ItemStack((ItemLike)item));
    }

    public ItemElement(int x, int y, float scale, ItemStack item) {
        this(x, y, scale, new ItemStack[]{item});
    }

    public ItemElement(int x, int y, float scale, Collection<ItemStack> itemCycle) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[0]));
    }

    public ItemElement(int x, int y, float scale, Collection<ItemStack> itemCycle, String action) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[0]), action);
    }

    public ItemElement(int x, int y, float scale, ItemStack ... itemCycle) {
        this(x, y, scale, itemCycle, (String)null);
    }

    public ItemElement(int x, int y, float scale, ItemStack[] itemCycle, @Nullable String action) {
        super(x, y, Mth.m_14143_((float)(16.0f * scale)), Mth.m_14143_((float)(16.0f * scale)));
        NonNullList nonNullStacks = NonNullList.m_122780_((int)itemCycle.length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemCycle.length; ++i) {
            if (itemCycle[i].m_41619_()) continue;
            nonNullStacks.set(i, (Object)itemCycle[i].m_41777_());
        }
        this.itemCycle = nonNullStacks;
        this.scale = scale;
        this.action = action;
    }

    @Override
    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        long nano = Util.m_137569_();
        if (nano > this.lastTime + 3000000000L) {
            this.lastTime = nano;
            ++this.currentItem;
            if (this.currentItem >= this.itemCycle.size()) {
                this.currentItem = 0;
            }
        }
        if (this.currentItem < this.itemCycle.size()) {
            PoseStack matrices = graphics.m_280168_();
            matrices.m_85836_();
            matrices.m_252880_((float)this.x, (float)this.y, 0.0f);
            matrices.m_85841_(this.scale, this.scale, 1.0f);
            ItemStack stack = (ItemStack)this.itemCycle.get(this.currentItem);
            graphics.m_280480_(stack, 0, 0);
            Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
            if (font == null) {
                font = this.mc.f_91062_;
            }
            graphics.m_280370_(font, stack, 0, 0);
            matrices.m_85849_();
        }
    }

    @Override
    public void drawOverlay(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        if (this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size()) {
            if (this.tooltip != null) {
                this.drawTooltip(graphics, this.tooltip, mouseX, mouseY, fontRenderer);
            } else {
                this.renderToolTip(graphics, fontRenderer, (ItemStack)this.itemCycle.get(this.currentItem), mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size() && !StringUtil.m_14408_((String)this.action)) {
            StringActionProcessor.process(this.action, this.parent);
        }
    }
}

