/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.structure.level;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

public class TemplateChunk
extends EmptyLevelChunk {
    private final Map<BlockPos, StructureTemplate.StructureBlockInfo> blocksInChunk;
    private final Map<BlockPos, BlockEntity> tiles;
    private final Predicate<BlockPos> shouldShow;

    public TemplateChunk(Level level, ChunkPos chunkPos, List<StructureTemplate.StructureBlockInfo> blocksInChunk, Predicate<BlockPos> shouldShow) {
        super(level, chunkPos, (Holder)level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
        this.shouldShow = shouldShow;
        this.blocksInChunk = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        this.tiles = new HashMap<BlockPos, BlockEntity>();
        for (StructureTemplate.StructureBlockInfo info : blocksInChunk) {
            BlockEntity tile;
            this.blocksInChunk.put(info.f_74675_(), info);
            if (info.f_74677_() == null || (tile = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_())) == null) continue;
            tile.m_142339_(level);
            this.tiles.put(info.f_74675_(), tile);
        }
    }

    public BlockState m_8055_(BlockPos pos) {
        StructureTemplate.StructureBlockInfo result;
        if (this.shouldShow.test(pos) && (result = this.blocksInChunk.get(pos)) != null) {
            return result.f_74676_();
        }
        return Blocks.f_50626_.m_49966_();
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    @Nullable
    public BlockEntity m_5685_(BlockPos pos, LevelChunk.EntityCreationType creationMode) {
        if (!this.shouldShow.test(pos)) {
            return null;
        }
        return this.tiles.get(pos);
    }
}

