/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;

public enum NodeRotation implements StringRepresentable
{
    NONE(null, null),
    Y_CLOCKWISE_90(Direction.Axis.Y, Rotation.CLOCKWISE_90),
    Y_CLOCKWISE_180(Direction.Axis.Y, Rotation.CLOCKWISE_180),
    Y_COUNTERCLOCKWISE_90(Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90),
    X_CLOCKWISE_90(Direction.Axis.X, Rotation.CLOCKWISE_90),
    X_CLOCKWISE_180(Direction.Axis.X, Rotation.CLOCKWISE_180),
    X_COUNTERCLOCKWISE_90(Direction.Axis.X, Rotation.COUNTERCLOCKWISE_90),
    Z_CLOCKWISE_90(Direction.Axis.Z, Rotation.CLOCKWISE_90),
    Z_CLOCKWISE_180(Direction.Axis.Z, Rotation.CLOCKWISE_180),
    Z_COUNTERCLOCKWISE_90(Direction.Axis.Z, Rotation.COUNTERCLOCKWISE_90);

    public static final EnumProperty<NodeRotation> ROTATION;
    public static final NodeRotation[] VALUES;
    final Direction.Axis axis;
    final Rotation rotation;

    private NodeRotation(Direction.Axis axis, Rotation rotation) {
        this.axis = axis;
        this.rotation = rotation;
    }

    public Direction rotate(Direction current, boolean handleY) {
        if (this == NONE) {
            return current;
        }
        if (!handleY && this.axis == Direction.Axis.Y && current.m_122434_() == Direction.Axis.Y) {
            return current;
        }
        if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
            return current.m_175364_(this.axis);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return current.m_175362_(this.axis);
        }
        return current.m_122424_();
    }

    public Vec3i updateRelative(Vec3i current) {
        if (this == NONE) {
            return current;
        }
        if (this.axis == Direction.Axis.Y) {
            if (this.rotation == Rotation.CLOCKWISE_90) {
                return new Vec3i(-current.m_123343_(), current.m_123342_(), current.m_123341_());
            }
            if (this.rotation == Rotation.CLOCKWISE_180) {
                return new Vec3i(-current.m_123341_(), current.m_123342_(), -current.m_123343_());
            }
            if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                return new Vec3i(current.m_123343_(), current.m_123342_(), -current.m_123341_());
            }
        }
        if (this.axis == Direction.Axis.X) {
            if (this.rotation == Rotation.CLOCKWISE_90) {
                return new Vec3i(current.m_123341_(), current.m_123343_(), -current.m_123342_());
            }
            if (this.rotation == Rotation.CLOCKWISE_180) {
                return new Vec3i(current.m_123341_(), -current.m_123342_(), -current.m_123343_());
            }
            if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                return new Vec3i(current.m_123341_(), -current.m_123343_(), current.m_123342_());
            }
        }
        if (this.axis == Direction.Axis.Z) {
            if (this.rotation == Rotation.CLOCKWISE_90) {
                return new Vec3i(current.m_123342_(), -current.m_123341_(), current.m_123343_());
            }
            if (this.rotation == Rotation.CLOCKWISE_180) {
                return new Vec3i(-current.m_123341_(), -current.m_123342_(), current.m_123343_());
            }
            if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                return new Vec3i(-current.m_123342_(), current.m_123341_(), current.m_123343_());
            }
        }
        return current;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static NodeRotation get(Direction.Axis axis, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return NONE;
        }
        for (NodeRotation wr : VALUES) {
            if (wr.axis != axis || wr.rotation != rotation) continue;
            return wr;
        }
        return NONE;
    }

    static {
        ROTATION = EnumProperty.m_61587_((String)"rotation", NodeRotation.class);
        VALUES = NodeRotation.values();
    }
}

