/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Orientation2D;
import slimeknights.tconstruct.tools.TinkerModifiers;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierClientEvents {
    private static final int SLOT_BACKGROUND_SIZE = 22;
    @Nonnull
    private static ItemStack nextOffhand = ItemStack.f_41583_;
    private static final List<ItemStack> itemFrames = new ArrayList<ItemStack>();

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() instanceof IModifiableDisplay) {
            event.getToolTip().removeIf(text -> {
                ComponentContents patt2852$temp = text.m_214077_();
                if (patt2852$temp instanceof TranslatableContents) {
                    TranslatableContents translatable = (TranslatableContents)patt2852$temp;
                    return translatable.m_237508_().equals("item.durability");
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    static void renderHand(RenderHandEvent event) {
        InteractionHand hand = event.getHand();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (hand != InteractionHand.OFF_HAND || player == null) {
            return;
        }
        ItemStack offhand = event.getItemStack();
        if (offhand.m_41619_() && !player.m_20145_() && player.m_21205_().m_41720_() != Items.f_42573_ && ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SHOW_EMPTY_OFFHAND) > 0) {
            PoseStack matrices = event.getPoseStack();
            matrices.m_85836_();
            Minecraft.m_91087_().m_91290_().m_234586_().m_109346_(matrices, event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), player.m_5737_().m_20828_());
            matrices.m_85849_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void handleZoom(ComputeFovModifierEvent event) {
        event.getPlayer().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            FloatMultiplier constZoom;
            FloatMultiplier scaledZoom;
            float newFov = event.getNewFovModifier();
            float effectScale = ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue();
            if (effectScale > 0.0f && (scaledZoom = data.get(TinkerDataKeys.SCALED_FOV_MODIFIER)) != null) {
                if (effectScale == 1.0f) {
                    newFov *= scaledZoom.getValue();
                } else {
                    float original = event.getFovModifier();
                    newFov *= Mth.m_14179_((float)effectScale, (float)1.0f, (float)(scaledZoom.getValue() * original)) / original;
                }
            }
            if ((constZoom = data.get(TinkerDataKeys.FOV_MODIFIER)) != null) {
                newFov *= constZoom.getValue();
            }
            event.setNewFovModifier(newFov);
        });
    }

    @SubscribeEvent
    static void equipmentChange(ToolEquipmentChangeEvent event) {
        ModifierEntry entry;
        IToolStackView tool;
        EquipmentChangeContext context = event.getContext();
        if (((Boolean)Config.CLIENT.renderShieldSlotItem.get()).booleanValue() && event.getEntity() == Minecraft.m_91087_().f_91074_ && context.getChangedSlot() == EquipmentSlot.LEGS) {
            tool = context.getToolInSlot(EquipmentSlot.LEGS);
            if (tool != null && (entry = tool.getModifiers().getEntry(TinkerModifiers.shieldStrap.getId())) != ModifierEntry.EMPTY) {
                nextOffhand = entry.getHook(ToolInventoryCapability.HOOK).getStack(tool, entry, 0);
                return;
            }
            nextOffhand = ItemStack.f_41583_;
        }
        if (((Boolean)Config.CLIENT.renderItemFrame.get()).booleanValue() && event.getEntity() == Minecraft.m_91087_().f_91074_ && context.getChangedSlot() == EquipmentSlot.HEAD) {
            itemFrames.clear();
            tool = context.getToolInSlot(EquipmentSlot.HEAD);
            if (tool != null && (entry = tool.getModifier(TinkerModifiers.itemFrame.getId())).intEffectiveLevel() > 0) {
                entry.getHook(ToolInventoryCapability.HOOK).getAllStacks(tool, entry, itemFrames);
            }
        }
    }

    @SubscribeEvent
    static void renderHotbar(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player;
        boolean renderItemFrame;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        boolean renderShield = (Boolean)Config.CLIENT.renderShieldSlotItem.get() != false && !nextOffhand.m_41619_();
        boolean bl = renderItemFrame = (Boolean)Config.CLIENT.renderItemFrame.get() != false && !itemFrames.isEmpty();
        if (!renderItemFrame && !renderShield) {
            return;
        }
        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
        if (playerController != null && playerController.m_105295_() != GameType.SPECTATOR && (player = Minecraft.m_91087_().f_91074_) != null && player == mc.m_91288_()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            GuiGraphics graphics = event.getGuiGraphics();
            float partialTicks = event.getPartialTick();
            if (renderShield) {
                int x = scaledWidth / 2 + (player.m_5737_().m_20828_() == HumanoidArm.LEFT ? -117 : 101);
                int y = scaledHeight - 38;
                graphics.m_280163_(Icons.ICONS, x - 3, y - 3, player.m_21206_().m_41619_() ? 211.0f : 189.0f, 0.0f, 22, 22, 256, 256);
                mc.f_91065_.m_280585_(graphics, x, y, partialTicks, (Player)player, nextOffhand, 11);
            }
            if (renderItemFrame) {
                int c;
                int columns = (Integer)Config.CLIENT.itemsPerRow.get();
                int count = itemFrames.size();
                int rows = count / columns;
                int inLastRow = count % columns;
                if (inLastRow == 0) {
                    inLastRow = columns;
                } else {
                    ++rows;
                }
                Orientation2D location = (Orientation2D)((Object)Config.CLIENT.itemFrameLocation.get());
                Orientation2D.Orientation1D xOrientation = location.getX();
                Orientation2D.Orientation1D yOrientation = location.getY();
                int xStart = xOrientation.align(scaledWidth - 22 * columns) + (Integer)Config.CLIENT.itemFrameXOffset.get();
                int yStart = yOrientation.align(scaledHeight - 22 * rows) + (Integer)Config.CLIENT.itemFrameYOffset.get();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)Icons.ICONS);
                int lastRow = rows - 1;
                for (int r = 0; r < lastRow; ++r) {
                    for (c = 0; c < columns; ++c) {
                        graphics.m_280163_(Icons.ICONS, xStart + c * 22, yStart + r * 22, 167.0f, 0.0f, 22, 22, 256, 256);
                    }
                }
                int lastRowOffset = xOrientation.align((columns - inLastRow) * 2) * 22 / 2;
                for (c = 0; c < inLastRow; ++c) {
                    graphics.m_280163_(Icons.ICONS, xStart + c * 22 + lastRowOffset, yStart + lastRow * 22, 167.0f, 0.0f, 22, 22, 256, 256);
                }
                int i = 0;
                xStart += 3;
                yStart += 3;
                for (int r = 0; r < lastRow; ++r) {
                    for (int c2 = 0; c2 < columns; ++c2) {
                        mc.f_91065_.m_280585_(graphics, xStart + c2 * 22, yStart + r * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                        ++i;
                    }
                }
                for (int c3 = 0; c3 < inLastRow; ++c3) {
                    mc.f_91065_.m_280585_(graphics, xStart + c3 * 22 + lastRowOffset, yStart + lastRow * 22, partialTicks, (Player)player, itemFrames.get(i), i);
                    ++i;
                }
            }
            RenderSystem.disableBlend();
        }
    }
}

