/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.item.CopperCanFluidHandler;

public class CopperCanItem
extends Item {
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_FLUID_TAG = "fluid_tag";

    public CopperCanItem(Item.Properties properties) {
        super(properties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CopperCanFluidHandler(stack);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return CopperCanItem.getFluid(stack) != Fluids.f_76191_;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (this.hasCraftingRemainingItem(stack)) {
            return new ItemStack((ItemLike)this);
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Fluid fluid = CopperCanItem.getFluid(stack);
        if (fluid != Fluids.f_76191_) {
            MutableComponent text;
            CompoundTag fluidTag = CopperCanItem.getFluidTag(stack);
            if (fluidTag != null) {
                FluidStack displayFluid = new FluidStack(fluid, 90, fluidTag);
                text = displayFluid.getDisplayName().m_6879_();
            } else {
                text = Component.m_237115_((String)fluid.getFluidType().getDescriptionId());
            }
            tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".contents"), (Object[])new Object[]{text}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void removeFluid(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_(TAG_FLUID);
            nbt.m_128473_(TAG_FLUID_TAG);
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    private static void setFluidInternal(ItemStack stack, ResourceLocation fluid, @Nullable CompoundTag fluidTag) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_(TAG_FLUID, fluid.toString());
        if (fluidTag != null) {
            nbt.m_128365_(TAG_FLUID_TAG, (Tag)fluidTag.m_6426_());
        } else {
            nbt.m_128473_(TAG_FLUID_TAG);
        }
    }

    public static ItemStack setFluid(ItemStack stack, ResourceLocation fluid, @Nullable CompoundTag fluidTag) {
        if (fluid.equals((Object)BuiltInRegistries.f_257020_.m_122315_())) {
            CopperCanItem.removeFluid(stack);
        } else {
            CopperCanItem.setFluidInternal(stack, fluid, fluidTag);
        }
        return stack;
    }

    public static ItemStack setFluid(ItemStack stack, Fluid fluid, @Nullable CompoundTag fluidTag) {
        if (fluid == Fluids.f_76191_) {
            CopperCanItem.removeFluid(stack);
        } else {
            CopperCanItem.setFluidInternal(stack, BuiltInRegistries.f_257020_.m_7981_((Object)fluid), fluidTag);
        }
        return stack;
    }

    public static ItemStack setFluid(ItemStack stack, FluidStack fluid) {
        return CopperCanItem.setFluid(stack, fluid.getFluid(), fluid.getTag());
    }

    public static Fluid getFluid(ItemStack stack) {
        Fluid fluid;
        ResourceLocation location;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && (location = ResourceLocation.m_135820_((String)nbt.m_128461_(TAG_FLUID))) != null && ForgeRegistries.FLUIDS.containsKey(location) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(location)) != null) {
            return fluid;
        }
        return Fluids.f_76191_;
    }

    public static void addFilledVariants(Consumer<ItemStack> output) {
        BuiltInRegistries.f_257020_.m_203611_().filter(holder -> {
            Fluid fluid = (Fluid)holder.get();
            return fluid.m_7444_(fluid.m_76145_()) && !holder.m_203656_(TinkerTags.Fluids.HIDE_IN_CREATIVE_TANKS);
        }).forEachOrdered(holder -> output.accept(CopperCanItem.setFluid(new ItemStack(TinkerSmeltery.copperCan), holder.m_205785_().m_135782_(), null)));
    }

    @Nullable
    public static CompoundTag getFluidTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_(TAG_FLUID_TAG, 10)) {
            return nbt.m_128469_(TAG_FLUID_TAG);
        }
        return null;
    }

    public static String getSubtype(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            return nbt.m_128461_(TAG_FLUID);
        }
        return "";
    }
}

