/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.RenderItem;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.tank.CastingFluidHandler;
import slimeknights.tconstruct.smeltery.client.util.CastingItemRenderTypeBuffer;

public class CastingBlockEntityRenderer
implements BlockEntityRenderer<CastingBlockEntity> {
    public CastingBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CastingBlockEntity casting, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int light, int combinedOverlayIn) {
        BlockState state = casting.m_58900_();
        List fluids = (List)FluidCuboid.REGISTRY.get(state, List.of());
        List renderItems = (List)RenderItem.REGISTRY.get((Object)state.m_60734_(), List.of());
        if (!fluids.isEmpty() || !renderItems.isEmpty()) {
            boolean isRotated = RenderingHelper.applyRotation((PoseStack)matrices, (BlockState)state);
            int timer = casting.getTimer();
            int totalTime = casting.getCoolingTime();
            int itemOpacity = 0;
            int fluidOpacity = 255;
            if (timer > 0 && totalTime > 0) {
                int opacity = 1020 * timer / totalTime;
                itemOpacity = opacity / 4;
                if (opacity > 765) {
                    fluidOpacity = 1020 - opacity;
                }
            }
            if (!fluids.isEmpty()) {
                CastingFluidHandler tank = casting.getTank();
                FluidStack fluidStack = tank.getFluid();
                int capacity = tank.getCapacity();
                if (fluidStack.getAmount() == capacity) {
                    for (FluidCuboid fluid : fluids) {
                        RenderUtils.renderTransparentCuboid(matrices, buffer, fluid, fluidStack, fluidOpacity, light);
                    }
                } else {
                    for (FluidCuboid fluid : fluids) {
                        FluidRenderer.renderScaledCuboid((PoseStack)matrices, (MultiBufferSource)buffer, (FluidCuboid)fluid, (FluidStack)fluidStack, (float)0.0f, (int)capacity, (int)light, (boolean)false);
                    }
                }
            }
            if (!renderItems.isEmpty()) {
                RenderItem outputModel;
                RenderingHelper.renderItem((PoseStack)matrices, (MultiBufferSource)buffer, (ItemStack)casting.m_8020_(0), (RenderItem)((RenderItem)renderItems.get(0)), (int)light);
                if (renderItems.size() >= 2 && !(outputModel = (RenderItem)renderItems.get(1)).isHidden()) {
                    ItemStack output = casting.m_8020_(1);
                    MultiBufferSource outputBuffer = buffer;
                    if (itemOpacity > 0 && output.m_41619_()) {
                        output = casting.getRecipeOutput();
                        outputBuffer = new CastingItemRenderTypeBuffer(buffer, itemOpacity, fluidOpacity);
                    }
                    RenderingHelper.renderItem((PoseStack)matrices, (MultiBufferSource)outputBuffer, (ItemStack)output, (RenderItem)outputModel, (int)light);
                }
            }
            if (isRotated) {
                matrices.m_85849_();
            }
        }
    }
}

