/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.shared.command.argument.MaterialArgument;

public class MaterialVariantArgument
implements ArgumentType<MaterialVariantId> {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.id.invalid"));

    public static MaterialVariantId getMaterial(CommandContext<CommandSourceStack> context, String name) {
        return (MaterialVariantId)context.getArgument(name, MaterialVariantId.class);
    }

    public MaterialVariantId parse(StringReader reader) throws CommandSyntaxException {
        MaterialVariantId material = MaterialVariantId.tryParse(reader);
        if (material == null) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
        return material;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(MaterialRegistry.getMaterials().stream().map(IMaterial::getIdentifier)::iterator, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return MaterialArgument.EXAMPLES;
    }

    private MaterialVariantArgument() {
    }

    public static MaterialVariantArgument material() {
        return new MaterialVariantArgument();
    }
}

