/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.fluid;

import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.Mantle;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.build.ModifierTraitModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.CapacityStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ToolTankHelper {
    public static final BiFunction<CompoundTag, String, FluidStack> PARSE_FLUID = (nbt, key) -> FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(key));
    public static final String MB_FORMAT = Mantle.makeDescriptionId((String)"gui", (String)"fluid.millibucket");
    public static final CapacityStat CAPACITY_STAT = ToolStats.register(new CapacityStat(new ToolStatId("tconstruct", "tank_capacity"), 0xA0A0A0, MB_FORMAT));
    public static final ToolTankHelper TANK_HELPER = new ToolTankHelper(CAPACITY_STAT, TConstruct.getResource("tank_fluid"));
    public static final ModifierModule TANK_HANDLER = new ModifierTraitModule(TinkerModifiers.tankHandler.getId(), 1, true);
    private final INumericToolStat<?> capacityStat;
    private final ResourceLocation fluidKey;

    public int getCapacity(IToolStackView tool) {
        return tool.getStats().getInt(this.capacityStat);
    }

    public FluidStack getFluid(IToolStackView tool) {
        return tool.getPersistentData().get(this.getFluidKey(), PARSE_FLUID);
    }

    public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
        if (fluid.isEmpty()) {
            tool.getPersistentData().remove(this.fluidKey);
            return FluidStack.EMPTY;
        }
        int capacity = this.getCapacity(tool);
        if ((fluid = fluid.copy()).getAmount() > capacity) {
            fluid.setAmount(capacity);
        }
        tool.getPersistentData().put(this.fluidKey, (Tag)fluid.writeToNBT(new CompoundTag()));
        return fluid;
    }

    public INumericToolStat<?> getCapacityStat() {
        return this.capacityStat;
    }

    public ResourceLocation getFluidKey() {
        return this.fluidKey;
    }

    public ToolTankHelper(INumericToolStat<?> capacityStat, ResourceLocation fluidKey) {
        this.capacityStat = capacityStat;
        this.fluidKey = fluidKey;
    }
}

