/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.LazyMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.IModifierMaterialRepairRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierMaterialRepairRecipe
extends TinkerStationRepairRecipe
implements IModifierMaterialRepairRecipe {
    public static final RecordLoadable<ModifierMaterialRepairRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)MODIFIER_FIELD, (RecordField)REPAIR_MATERIAL_FIELD, (RecordField)STAT_TYPE_FIELD, ModifierMaterialRepairRecipe::new);
    private final ModifierId modifier;
    private final LazyMaterial repairMaterial;
    private MaterialStatsId statType;

    public ModifierMaterialRepairRecipe(ResourceLocation id, ModifierId modifier, MaterialId repairMaterialID, MaterialStatsId statType) {
        super(id);
        this.modifier = modifier;
        this.repairMaterial = LazyMaterial.of(repairMaterialID);
        this.statType = statType;
    }

    @Override
    public MaterialId getRepairMaterial() {
        return this.repairMaterial.getId();
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (this.repairMaterial.isUnknown()) {
            return false;
        }
        ItemStack tinkerable = inv.getTinkerableStack();
        if (!tinkerable.m_204117_(TinkerTags.Items.MODIFIABLE) || ModifierUtil.getModifierLevel(tinkerable, this.modifier) == 0) {
            return false;
        }
        return ModifierMaterialRepairRecipe.findMaterialItem(inv, this.repairMaterial.getId());
    }

    @Override
    protected float getRepairAmount(IToolStackView tool, MaterialId repairMaterial) {
        return MaterialRepairModule.getDurability(tool.getDefinition().getId(), repairMaterial, this.statType) * tool.getModifierLevel(this.modifier);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierMaterialRepair.get();
    }

    private static boolean findMaterialItem(ITinkerStationContainer inv, MaterialId repairMaterial) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (!repairMaterial.equals(TinkerStationRepairRecipe.getMaterialFrom(inv, i))) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public MaterialStatsId getStatType() {
        return this.statType;
    }
}

