/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.technical;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.MaxArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MaxArmorStatModule(TinkerDataCapability.TinkerDataKey<Float> statKey, LevelingValue amount, TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> maxLevel, boolean allowBroken, @Nullable TagKey<Item> heldTag, ArmorStatModule.TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) implements ModifierModule,
TooltipModifierHook,
MaxArmorLevelModule
{
    public static final RecordLoadable<MaxArmorStatModule> LOADER = RecordLoadable.create((RecordField)TinkerDataKeys.FLOAT_REGISTRY.requiredField("key", MaxArmorStatModule::statKey), (RecordField)LevelingValue.LOADABLE.directField(MaxArmorStatModule::amount), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_broken", Boolean.valueOf(false), MaxArmorStatModule::allowBroken), (RecordField)Loadables.ITEM_TAG.nullableField("held_tag", MaxArmorStatModule::heldTag), (RecordField)new EnumLoadable(ArmorStatModule.TooltipStyle.class).defaultField("tooltip_style", (Object)ArmorStatModule.TooltipStyle.NONE, MaxArmorStatModule::tooltipStyle), ModifierCondition.TOOL_FIELD, MaxArmorStatModule::new);

    private MaxArmorStatModule(TinkerDataCapability.TinkerDataKey<Float> statKey, LevelingValue amount, boolean allowBroken, @Nullable TagKey<Item> heldTag, ArmorStatModule.TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) {
        this(statKey, amount, MaxArmorLevelModule.createKey(statKey.getId()), allowBroken, heldTag, tooltipStyle, condition);
    }

    public RecordLoadable<MaxArmorStatModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return this.tooltipStyle == ArmorStatModule.TooltipStyle.NONE ? NO_TOOLTIP_HOOKS : TOOLTIP_HOOKS;
    }

    @Override
    public void updateValue(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, TinkerDataCapability.Holder data, float newLevel, float oldLevel) {
        data.add(this.statKey, this.amount.computeForLevel(newLevel) - this.amount.computeForLevel(oldLevel));
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (MaxArmorLevelModule.shouldAddTooltip(this, tool, modifier, player)) {
            ArmorStatModule.addStatTooltip(modifier, this.statKey.getId(), this.amount.computeForLevel(modifier.getEffectiveLevel()), this.tooltipStyle, tooltip);
        }
    }

    public static Builder builder(TinkerDataCapability.TinkerDataKey<Float> statKey) {
        return new Builder(statKey);
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<MaxArmorStatModule> {
        private final TinkerDataCapability.TinkerDataKey<Float> statKey;
        private boolean allowBroken = false;
        @Nullable
        private TagKey<Item> heldTag;
        private ArmorStatModule.TooltipStyle tooltipStyle = ArmorStatModule.TooltipStyle.NONE;

        public Builder allowBroken() {
            this.allowBroken = true;
            return this;
        }

        @Override
        public MaxArmorStatModule amount(float flat, float eachLevel) {
            return new MaxArmorStatModule(this.statKey, new LevelingValue(flat, eachLevel), this.allowBroken, this.heldTag, this.tooltipStyle, this.condition);
        }

        public Builder allowBroken(boolean allowBroken) {
            this.allowBroken = allowBroken;
            return this;
        }

        public Builder heldTag(@Nullable TagKey<Item> heldTag) {
            this.heldTag = heldTag;
            return this;
        }

        public Builder tooltipStyle(ArmorStatModule.TooltipStyle tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }

        private Builder(TinkerDataCapability.TinkerDataKey<Float> statKey) {
            this.statKey = statKey;
        }
    }
}

