/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.tool.ToolFormula;
import slimeknights.tconstruct.library.json.variable.tool.ToolVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record AttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, ToolFormula formula, UUID[] slotUUIDs, ModifierCondition<IToolStackView> condition) implements AttributesModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final String[] VARIABLES = new String[]{"level"};
    private static final RecordLoadable<ToolFormula> VARIABLE_LOADER = new VariableFormulaLoadable<ToolVariable, ToolFormula>(ToolVariable.LOADER, VARIABLES, ModifierFormula.FallbackFormula.IDENTITY, (formula, variables, percent) -> new ToolFormula((ModifierFormula)formula, (List<ToolVariable>)variables, VariableFormula.EMPTY_STRINGS));
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ATTRIBUTES);
    public static final RecordLoadable<AttributeModule> LOADER = RecordLoadable.create((RecordField)StringLoadable.DEFAULT.requiredField("unique", AttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", AttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", AttributeModule::operation), (RecordField)VARIABLE_LOADER.directField(AttributeModule::formula), (RecordField)TinkerLoadables.EQUIPMENT_SLOT_SET.requiredField("slots", m -> AttributeModule.uuidsToSlots(m.slotUUIDs)), ModifierCondition.TOOL_FIELD, (unique, attribute, operation, amount, slots, condition) -> new AttributeModule((String)unique, (Attribute)attribute, (AttributeModifier.Operation)operation, (ToolFormula)amount, AttributeModule.slotsToUUIDs(unique, slots), (ModifierCondition<IToolStackView>)condition));

    public static UUID getUUID(String name, EquipmentSlot slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.m_20751_()).getBytes());
    }

    public static UUID[] slotsToUUIDs(String name, Collection<EquipmentSlot> slots) {
        UUID[] slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            slotUUIDs[slot.m_20750_()] = AttributeModule.getUUID(name, slot);
        }
        return slotUUIDs;
    }

    public static Set<EquipmentSlot> uuidsToSlots(UUID[] uuids) {
        EnumSet<EquipmentSlot> set = EnumSet.noneOf(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (uuids[slot.m_20750_()] == null) continue;
            set.add(slot);
        }
        return set;
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        UUID uuid;
        if (this.condition.matches(tool, modifier) && (uuid = this.slotUUIDs[slot.m_20750_()]) != null) {
            consumer.accept(this.attribute, new AttributeModifier(uuid, this.unique + "." + slot.m_20751_(), (double)this.formula.apply(tool, modifier), this.operation));
        }
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<AttributeModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, AttributeModule, ToolVariable> {
        protected final Attribute attribute;
        protected final AttributeModifier.Operation operation;
        protected String unique;
        private EquipmentSlot[] slots = EquipmentSlot.values();

        protected Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(VARIABLES);
            this.attribute = attribute;
            this.operation = operation;
        }

        public Builder slots(EquipmentSlot ... slots) {
            this.slots = slots;
            return this;
        }

        public Builder unique(String unique) {
            this.unique = unique;
            return this;
        }

        public Builder uniqueFrom(ResourceLocation id) {
            return this.unique(id.m_135827_() + ".modifier." + id.m_135815_());
        }

        @Override
        protected AttributeModule build(ModifierFormula formula) {
            if (this.unique == null) {
                throw new IllegalStateException("Must set unique for attributes");
            }
            return new AttributeModule(this.unique, this.attribute, this.operation, new ToolFormula(formula, this.variables), AttributeModule.slotsToUUIDs(this.unique, List.of(this.slots)), this.condition);
        }
    }
}

