/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.IncrementalModifierEntry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public abstract class DurabilityShieldModifier
extends Modifier
implements ToolDamageModifierHook,
ValidateModifierHook,
ModifierRemovalHook,
DurabilityDisplayModifierHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.TOOL_DAMAGE, ModifierHooks.VALIDATE, ModifierHooks.REMOVE, ModifierHooks.DURABILITY_DISPLAY);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return IncrementalModifierEntry.addAmountToName(this.getDisplayName(entry.getLevel()), this.getShield(tool), this.getShieldCapacity(tool, entry));
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        int cap = this.getShieldCapacity(tool, modifier);
        if (this.getShield(tool) > cap) {
            this.setShield(tool.getPersistentData(), cap);
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.getShieldKey());
        return null;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            if (shield >= amount) {
                this.setShield(tool, modifier, shield - amount);
                return 0;
            }
            amount -= shield;
            this.setShield(tool, modifier, 0);
        }
        return amount;
    }

    @Override
    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            return DurabilityDisplayModifierHook.getWidthFor(shield, this.getShieldCapacity(tool, modifier));
        }
        return 0;
    }

    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    public int getShield(IToolStackView tool) {
        return tool.getPersistentData().getInt(this.getShieldKey());
    }

    public abstract int getShieldCapacity(IToolStackView var1, ModifierEntry var2);

    public void setShield(ModDataNBT persistentData, int amount) {
        persistentData.putInt(this.getShieldKey(), Math.max(amount, 0));
    }

    public void setShield(IToolStackView tool, ModifierEntry modifier, int amount) {
        this.setShield(tool.getPersistentData(), Math.min(amount, this.getShieldCapacity(tool, modifier)));
    }

    protected void addShield(IToolStackView tool, ModifierEntry modifier, int amount) {
        this.setShield(tool, modifier, amount + this.getShield(tool));
    }
}

