/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.impl.BasicModifier;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.module.WithHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ComposableModifier
extends BasicModifier {
    public static final RecordLoadable<ComposableModifier> LOADER = RecordLoadable.create((RecordField)ModifierLevelDisplay.LOADER.defaultField("level_display", true, m -> m.levelDisplay), (RecordField)new EnumLoadable(BasicModifier.TooltipDisplay.class).defaultField("tooltip_display", (Object)BasicModifier.TooltipDisplay.ALWAYS, true, m -> m.tooltipDisplay), (RecordField)IntLoadable.ANY_FULL.defaultField("priority", (Object)Integer.MIN_VALUE, m -> m.priority), (RecordField)ModifierModule.WITH_HOOKS.list(0).defaultField("modules", List.of(), m -> m.modules), (RecordField)ErrorFactory.FIELD, (level, tooltip, priority, modules, error) -> new ComposableModifier((ModifierLevelDisplay)level, (BasicModifier.TooltipDisplay)((Object)tooltip), priority == Integer.MIN_VALUE ? ComposableModifier.computePriority(modules) : priority, (List<WithHooks<ModifierModule>>)modules, (ErrorFactory)error));
    private final List<WithHooks<ModifierModule>> modules;

    protected ComposableModifier(ModifierLevelDisplay levelDisplay, BasicModifier.TooltipDisplay tooltipDisplay, int priority, List<WithHooks<ModifierModule>> modules, ErrorFactory error) {
        super(ModuleHookMap.createMap(modules, error), levelDisplay, tooltipDisplay, priority);
        this.modules = modules;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return this.getHook(ModifierHooks.DISPLAY_NAME).getDisplayName(tool, entry, entry.getDisplayName(), access);
    }

    private static int computePriority(List<WithHooks<ModifierModule>> modules) {
        ArrayList<ModifierModule> priorityModules = new ArrayList<ModifierModule>();
        for (WithHooks<ModifierModule> module2 : modules) {
            if (module2.module().getPriority() == null) continue;
            priorityModules.add(module2.module());
        }
        if (!priorityModules.isEmpty()) {
            int firstPriority = ((ModifierModule)priorityModules.get(0)).getPriority();
            for (int i = 1; i < priorityModules.size(); ++i) {
                if (((ModifierModule)priorityModules.get(i)).getPriority() == firstPriority) continue;
                TConstruct.LOG.warn("Multiple modules disagree on the preferred priority for composable modifier, choosing priority {}. Set the priority manually to silence this warning. All opinions: \n{}", (Object)firstPriority, (Object)priorityModules.stream().map(module -> "* " + module + ": " + module.getPriority()).collect(Collectors.joining("\n")));
                break;
            }
            return firstPriority;
        }
        return 100;
    }

    public static class Builder {
        private ModifierLevelDisplay levelDisplay = ModifierLevelDisplay.DEFAULT;
        private BasicModifier.TooltipDisplay tooltipDisplay = BasicModifier.TooltipDisplay.ALWAYS;
        private int priority = Integer.MIN_VALUE;
        private final ImmutableList.Builder<WithHooks<ModifierModule>> modules = ImmutableList.builder();

        public final Builder addModule(ModifierModule module) {
            this.modules.add(new WithHooks<ModifierModule>(module, Collections.emptyList()));
            return this;
        }

        public final Builder addModules(ModifierModule ... modules) {
            for (ModifierModule module : modules) {
                this.addModule(module);
            }
            return this;
        }

        @SafeVarargs
        public final <T extends ModifierModule> Builder addModule(T object, ModuleHook<? super T> ... hooks) {
            this.modules.add(new WithHooks<T>(object, List.of(hooks)));
            return this;
        }

        public ComposableModifier build() {
            ImmutableList modules = this.modules.build();
            if (this.priority == Integer.MIN_VALUE) {
                ComposableModifier.computePriority((List<WithHooks<ModifierModule>>)modules);
            }
            return new ComposableModifier(this.levelDisplay, this.tooltipDisplay, this.priority, (List<WithHooks<ModifierModule>>)modules, ErrorFactory.RUNTIME);
        }

        private Builder() {
        }

        public Builder levelDisplay(ModifierLevelDisplay levelDisplay) {
            this.levelDisplay = levelDisplay;
            return this;
        }

        public Builder tooltipDisplay(BasicModifier.TooltipDisplay tooltipDisplay) {
            this.tooltipDisplay = tooltipDisplay;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }
    }
}

