/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record FluidEffects(FluidIngredient ingredient, List<FluidEffect<? super FluidEffectContext.Block>> blockEffects, List<FluidEffect<? super FluidEffectContext.Entity>> entityEffects, boolean hidden) {
    public static final RecordLoadable<FluidEffects> LOADABLE = RecordLoadable.create((RecordField)FluidIngredient.LOADABLE.requiredField("fluid", e -> e.ingredient), (RecordField)FluidEffect.BLOCK_EFFECTS.list(0).defaultField("block_effects", List.of(), e -> e.blockEffects), (RecordField)FluidEffect.ENTITY_EFFECTS.list(0).defaultField("entity_effects", List.of(), e -> e.entityEffects), (RecordField)BooleanLoadable.INSTANCE.defaultField("hidden", (Object)false, false, e -> e.hidden), FluidEffects::new);

    public boolean matches(Fluid fluid) {
        return this.ingredient.test(fluid);
    }

    public int getAmount(Fluid fluid) {
        return this.ingredient.getAmount(fluid);
    }

    public boolean hasEffects() {
        return this.hasBlockEffects() || this.hasEntityEffects();
    }

    public boolean hasBlockEffects() {
        return !this.blockEffects.isEmpty();
    }

    public boolean hasEntityEffects() {
        return !this.entityEffects.isEmpty();
    }

    private <C extends FluidEffectContext> int apply(FluidStack fluid, float level, C context, List<FluidEffect<? super C>> effects, IFluidHandler.FluidAction action) {
        int amountPerLevel = this.getAmount(fluid.getFluid());
        float scale = (float)fluid.getAmount() >= (float)amountPerLevel * level ? level : (float)fluid.getAmount() / (float)amountPerLevel;
        EffectLevel effectLevel = new EffectLevel(scale, level);
        float usedScale = 0.0f;
        for (FluidEffect<C> fluidEffect : effects) {
            float newScale = fluidEffect.apply(fluid, effectLevel, context, action);
            if (!(newScale > usedScale)) continue;
            usedScale = newScale;
        }
        return (int)Math.ceil((float)amountPerLevel * Math.min(scale, usedScale));
    }

    public int applyToBlock(FluidStack fluid, float level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        return this.apply(fluid, level, context, this.blockEffects, action);
    }

    public int applyToEntity(FluidStack fluid, float level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        return this.apply(fluid, level, context, this.entityEffects, action);
    }

    public record Entry(ResourceLocation name, FluidEffects effects) {
        public static final RecordLoadable<Entry> LOADABLE = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("name", Entry::name), (RecordField)LOADABLE.requiredField("effects", Entry::effects), Entry::new);
    }
}

