/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.stat;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ConditionalStatFormula(ModifierFormula formula, List<ConditionalStatVariable> variables, String[] variableNames, boolean percent) implements VariableFormula<ConditionalStatVariable>
{
    public static final String[] VARIABLES = new String[]{"level", "value", "multiplier"};
    public static final RecordLoadable<ConditionalStatFormula> LOADER = new VariableFormulaLoadable<ConditionalStatVariable, ConditionalStatFormula>(ConditionalStatVariable.LOADER, VARIABLES, (formula, variables, percent) -> new ConditionalStatFormula((ModifierFormula)formula, (List<ConditionalStatVariable>)variables, EMPTY_STRINGS, (boolean)percent));

    public ConditionalStatFormula(ModifierFormula formula, Map<String, ConditionalStatVariable> variables, boolean percent) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables), percent);
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity entity, float value, float multiplier) {
        int size = this.variables.size();
        float[] arguments = new float[3 + size];
        arguments[0] = this.formula.processLevel(modifier);
        arguments[1] = value;
        arguments[2] = multiplier;
        for (int i = 0; i < size; ++i) {
            arguments[3 + i] = this.variables.get(i).getValue(tool, entity);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity entity, float value, float multiplier) {
        return this.formula.apply(this.getArguments(tool, modifier, entity, value, multiplier));
    }
}

