/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import org.jetbrains.annotations.Nullable;

public record MountedStorageUpdateMessage(int contraptionEntityId, BlockPos localPos, ItemStack storageStack, boolean refreshBlockRender) {
    public static void encode(MountedStorageUpdateMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.contraptionEntityId);
        buffer.m_130064_(msg.localPos);
        buffer.m_130055_(msg.storageStack);
        buffer.writeBoolean(msg.refreshBlockRender);
    }

    public static MountedStorageUpdateMessage decode(FriendlyByteBuf buffer) {
        return new MountedStorageUpdateMessage(buffer.readInt(), buffer.m_130135_(), buffer.m_130267_(), buffer.readBoolean());
    }

    static void onMessage(MountedStorageUpdateMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MountedStorageUpdateMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(MountedStorageUpdateMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(msg.contraptionEntityId());
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            @Nullable MountedStorageBase mountedStorage = ContraptionHelper.getMountedStorage(contraptionEntity, msg.localPos());
            if (mountedStorage == null) {
                return;
            }
            mountedStorage.updateWithSyncedStorageStack(msg.storageStack(), msg.refreshBlockRender());
        }
    }
}

