/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public interface HeatBlockEntity {
    public float getHeat();

    public void addHeat(float var1);

    public void setHeat(float var1);

    default public boolean canConnect(Direction from) {
        return true;
    }

    default public boolean canAdd(Direction from) {
        return this.canConnect(from);
    }

    default public float maxHeat() {
        return 10000.0f;
    }

    default public float getTierHeat() {
        return this.getHeat();
    }

    @Nullable
    default public float[] getHeatTiers() {
        return new float[0];
    }

    default public double getHeatTierMultiplier() {
        return 1.0;
    }

    public static <T extends BlockEntity> void addToolTips(T self, List<Component> tooltip) {
        LangBuilder builder = CreateLang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(((HeatBlockEntity)self).getHeat())});
        float max = ((HeatBlockEntity)self).maxHeat() * (float)((Double)NewAgeConfig.getCommon().overheatingMultiplier.get()).doubleValue();
        if (max < 0.0f) {
            builder.style(ChatFormatting.AQUA);
        } else if (((HeatBlockEntity)self).getHeat() >= max) {
            builder.style(ChatFormatting.DARK_RED);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.9) {
            builder.style(ChatFormatting.RED);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.75) {
            builder.style(ChatFormatting.GOLD);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.65) {
            builder.style(ChatFormatting.YELLOW);
        } else {
            builder.style(ChatFormatting.AQUA);
        }
        builder.add(CreateLang.text((String)" / ").add(CreateLang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{max > 0.0f ? StringFormattingTool.formatFloat(max) : "\u221e"})).style(ChatFormatting.DARK_GRAY));
        builder.forGoggles(tooltip, 1);
        float[] tiers = ((HeatBlockEntity)self).getHeatTiers();
        if (tiers == null) {
            return;
        }
        float mult = (float)((HeatBlockEntity)self).getHeatTierMultiplier();
        float tierHeat = ((HeatBlockEntity)self).getTierHeat();
        for (int i = 0; i < tiers.length; ++i) {
            float tis = tiers[i] * mult;
            float next = Float.MAX_VALUE;
            if (tiers.length > i + 1) {
                next = tiers[i + 1] * mult;
            }
            if (tis <= tierHeat && next > tierHeat) {
                builder = CreateLang.text((String)"> ").add(CreateLang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(tis)}));
                builder.style(ChatFormatting.GRAY);
                builder.forGoggles(tooltip, 0);
                continue;
            }
            builder = CreateLang.text((String)"").add(CreateLang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(tis)}));
            builder.style(ChatFormatting.DARK_GRAY);
            builder.forGoggles(tooltip, 2);
        }
    }

    public static <T extends BlockEntity> void handleOverheat(T self, Runnable onOverHeat) {
        if (self.m_58904_() == null) {
            return;
        }
        double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
        if (multiplier > 0.0 && (double)((HeatBlockEntity)self).getHeat() > (double)((HeatBlockEntity)self).maxHeat() * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get() * (double)0.7f) {
            ((HeatBlockEntity)self).setHeat(Math.max(((HeatBlockEntity)self).getHeat() - 100.0f, 0.0f));
            if ((double)((HeatBlockEntity)self).getHeat() > (double)((HeatBlockEntity)self).maxHeat() * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get()) {
                onOverHeat.run();
            }
        }
    }

    public static <T extends BlockEntity> void handleOverheat(T self) {
        HeatBlockEntity.handleOverheat(self, () -> self.m_58904_().m_7731_(self.m_58899_(), Blocks.f_49991_.m_49966_(), 3));
    }

    public static <T extends BlockEntity> void transferAround(T self) {
        if (self.m_58904_() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            HeatBlockEntity hbe;
            Direction value = Direction.values()[i];
            BlockEntity entity = self.m_58904_().m_7702_(self.m_58899_().m_121945_(value));
            if (!(entity instanceof HeatBlockEntity) || !(hbe = (HeatBlockEntity)entity).canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
        self.m_6596_();
    }

    public static <T extends BlockEntity> void trySync(T self) {
        Level level = self.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (self.m_58904_().m_46467_() % 160L == 0L) {
                BlockState state = self.m_58900_();
                level2.m_7260_(self.m_58899_(), state, state, 3);
            }
        }
    }

    public static <T extends BlockEntity> void average(T self, float totalToAverage, int totalBlocks, HeatBlockEntity[] setters) {
        float setAmount = totalToAverage / (float)totalBlocks;
        ((HeatBlockEntity)self).setHeat(setAmount);
        int i = 0;
        for (HeatBlockEntity hbe : setters) {
            if (hbe != null) {
                hbe.setHeat(setAmount);
            }
            ++i;
        }
    }
}

