/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.mixin;

import immersive_aircraft.entity.VehicleEntity;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileUtil.class})
public class ProjectileUtilMixin {
    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void ia$getEntityHitResult(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance, CallbackInfoReturnable<EntityHitResult> cir) {
        ProjectileUtilMixin.ia$vehicleTrace((EntityHitResult)cir.getReturnValue(), shooter.m_9236_(), shooter, startVec, endVec, boundingBox, filter, 0.0f, distance).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;F)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void ia$getEntityHitResult(Level level, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, float inflationAmount, CallbackInfoReturnable<EntityHitResult> cir) {
        ProjectileUtilMixin.ia$vehicleTrace((EntityHitResult)cir.getReturnValue(), level, projectile, startVec, endVec, boundingBox, filter, inflationAmount, Double.MAX_VALUE).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Unique
    private static Optional<EntityHitResult> ia$vehicleTrace(@Nullable EntityHitResult previous, Level level, @Nullable Entity source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, float inflationAmount, double distance) {
        double bestDistance = previous == null ? distance : previous.m_82450_().m_82557_(startVec);
        VehicleEntity entity = null;
        Vec3 collision = null;
        for (Entity e : level.m_6249_(source, boundingBox.m_82400_(16.0), VehicleEntity.class::isInstance)) {
            VehicleEntity vehicle;
            if (!(e instanceof VehicleEntity) || !filter.test(vehicle = (VehicleEntity)e)) continue;
            for (AABB aabb : vehicle.getAdditionalShapes()) {
                Vec3 newCollision;
                double dist;
                Optional optionalCollision = aabb.m_82400_((double)inflationAmount).m_82371_(startVec, endVec);
                if (!optionalCollision.isPresent() || !((dist = startVec.m_82557_(newCollision = (Vec3)optionalCollision.get())) < bestDistance)) continue;
                entity = vehicle;
                collision = newCollision;
                bestDistance = dist;
            }
        }
        return entity == null ? Optional.empty() : Optional.of(new EntityHitResult(entity, collision));
    }
}

