/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.ponder.element.BeltItemElement;
import com.simibubi.create.foundation.ponder.element.ExpandedParrotElement;
import com.simibubi.create.foundation.ponder.instruction.AnimateBlockEntityInstruction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.data.FunctionalHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotElement;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.element.PonderElement;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderSceneBuilder;
import net.createmod.ponder.foundation.element.ElementLinkImpl;
import net.createmod.ponder.foundation.instruction.CreateParrotInstruction;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CreateSceneBuilder
extends PonderSceneBuilder {
    private final EffectInstructions effects = new EffectInstructions();
    private final WorldInstructions world = new WorldInstructions();
    private final SpecialInstructions special = new SpecialInstructions();

    public CreateSceneBuilder(SceneBuilder baseSceneBuilder) {
        this(baseSceneBuilder.getScene());
    }

    private CreateSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
    }

    public EffectInstructions effects() {
        return this.effects;
    }

    public WorldInstructions world() {
        return this.world;
    }

    public SpecialInstructions special() {
        return this.special;
    }

    public class EffectInstructions
    extends PonderSceneBuilder.PonderEffectInstructions {
        public EffectInstructions() {
            super((PonderSceneBuilder)CreateSceneBuilder.this);
        }

        public void superGlue(BlockPos pos, Direction side, boolean fullBlock) {
            CreateSceneBuilder.this.addInstruction(scene -> SuperGlueItem.spawnParticles((Level)scene.getWorld(), pos, side, fullBlock));
        }

        private void rotationIndicator(BlockPos pos, boolean direction, BlockPos displayPos) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BlockState blockState = scene.getWorld().m_8055_(pos);
                BlockEntity blockEntity = scene.getWorld().m_7702_(pos);
                Block patt4271$temp = blockState.m_60734_();
                if (!(patt4271$temp instanceof KineticBlock)) {
                    return;
                }
                KineticBlock kb = (KineticBlock)patt4271$temp;
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
                Direction.Axis rotationAxis = kb.getRotationAxis(blockState);
                float speed = kbe.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? (speed > 0.0f ? 15425035 : 1476519) : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
                Vec3 location = VecHelper.getCenterOf((Vec3i)displayPos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, kb.getParticleInitialRadius(), kb.getParticleTargetRadius(), 20, rotationAxis.name().charAt(0));
                for (int i = 0; i < 20; ++i) {
                    scene.getWorld().m_7106_((ParticleOptions)particleData, location.f_82479_, location.f_82480_, location.f_82481_, 0.0, 0.0, 0.0);
                }
            });
        }

        public void rotationSpeedIndicator(BlockPos pos) {
            this.rotationIndicator(pos, false, pos);
        }

        public void rotationDirectionIndicator(BlockPos pos) {
            this.rotationIndicator(pos, true, pos);
        }
    }

    public class WorldInstructions
    extends PonderSceneBuilder.PonderWorldInstructions {
        public WorldInstructions() {
            super((PonderSceneBuilder)CreateSceneBuilder.this);
        }

        public void rotateBearing(BlockPos pos, float angle, int duration) {
            CreateSceneBuilder.this.addInstruction((PonderInstruction)AnimateBlockEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction((PonderInstruction)AnimateBlockEntityInstruction.pulley(pos, distance, duration));
        }

        public void animateBogey(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction((PonderInstruction)AnimateBlockEntityInstruction.bogey(pos, distance, duration + 1));
        }

        public void moveDeployer(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction((PonderInstruction)AnimateBlockEntityInstruction.deployer(pos, distance, duration));
        }

        public void createItemOnBeltLike(BlockPos location, Direction insertionSide, ItemStack stack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                BlockEntity blockEntity = world.m_7702_(location);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null) {
                    return;
                }
                behaviour.handleInsertion(stack, insertionSide.m_122424_(), false);
            });
            this.flapFunnel(location.m_7494_(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(BlockPos beltLocation, Direction insertionSide, ItemStack stack) {
            ElementLinkImpl link = new ElementLinkImpl(BeltItemElement.class);
            CreateSceneBuilder.this.addInstruction(arg_0 -> WorldInstructions.lambda$createItemOnBelt$2(beltLocation, stack, insertionSide, (ElementLink)link, arg_0));
            this.flapFunnel(beltLocation.m_7494_(), true);
            return link;
        }

        public void removeItemsFromBelt(BlockPos beltLocation) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getWorld();
                BlockEntity blockEntity = world.m_7702_(beltLocation);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null) {
                    return;
                }
                transporter.handleCenteredProcessingOnAllItems(0.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.locked = stalled;
                    });
                }
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, ItemStack newStack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.stack = newStack;
                    });
                }
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(speed));
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(f.floatValue() * modifier));
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            this.modifyBlockEntityNBT(selection, SpeedGaugeBlockEntity.class, nbt -> {
                float newSpeed = ((Float)speedFunc.apply(Float.valueOf(nbt.m_128457_("Speed")))).floatValue();
                nbt.m_128350_("Value", SpeedGaugeBlockEntity.getDialTarget(newSpeed));
            });
            this.modifyBlockEntityNBT(selection, KineticBlockEntity.class, nbt -> nbt.m_128350_("Speed", ((Float)speedFunc.apply(Float.valueOf(nbt.m_128457_("Speed")))).floatValue()));
        }

        public void propagatePipeChange(BlockPos pos) {
            this.modifyBlockEntity(pos, PumpBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        }

        public void setFilterData(Selection selection, Class<? extends BlockEntity> teType, ItemStack filter) {
            this.modifyBlockEntityNBT(selection, teType, nbt -> nbt.m_128365_("Filter", (Tag)filter.serializeNBT()));
        }

        public void instructArm(BlockPos armLocation, ArmBlockEntity.Phase phase, ItemStack heldItem, int targetedPoint) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.scene.getSceneBuildingUtil().select().position(armLocation), ArmBlockEntity.class, compound -> {
                NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)phase);
                compound.m_128365_("HeldItem", (Tag)heldItem.serializeNBT());
                compound.m_128405_("TargetPointIndex", targetedPoint);
                compound.m_128350_("MovementProgress", 0.0f);
            });
        }

        public void flapFunnel(BlockPos position, boolean outward) {
            this.modifyBlockEntity(position, FunnelBlockEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(BlockPos crafter, ItemStack output) {
            this.modifyBlockEntity(crafter, MechanicalCrafterBlockEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(BlockPos position1, BlockPos position2) {
            CreateSceneBuilder.this.addInstruction(s -> {
                ConnectedInputHandler.toggleConnection((Level)s.getWorld(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }

        public void toggleControls(BlockPos position) {
            this.cycleBlockProperty(position, (Property)ControlsBlock.VIRTUAL);
        }

        public void animateTrainStation(BlockPos position, boolean trainPresent) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), StationBlockEntity.class, c -> c.m_128379_("ForceFlag", trainPresent));
        }

        public void conductorBlaze(BlockPos position, boolean conductor) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), BlazeBurnerBlockEntity.class, c -> c.m_128379_("TrainHat", conductor));
        }

        public void changeSignalState(BlockPos position, SignalBlockEntity.SignalState state) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), SignalBlockEntity.class, c -> NBTHelper.writeEnum((CompoundTag)c, (String)"State", (Enum)state));
        }

        public void setDisplayBoardText(BlockPos position, int line, Component text) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.applyTextManually(line, Component.Serializer.m_130703_((Component)text)));
        }

        public void dyeDisplayBoard(BlockPos position, int line, DyeColor color) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.setColour(line, color));
        }

        public void flashDisplayLink(BlockPos position) {
            this.modifyBlockEntity(position, LinkWithBulbBlockEntity.class, linkBlockEntity -> linkBlockEntity.pulse());
        }

        private static /* synthetic */ void lambda$createItemOnBelt$2(BlockPos beltLocation, ItemStack stack, Direction insertionSide, ElementLink link, PonderScene scene) {
            PonderLevel world = scene.getWorld();
            BlockEntity blockEntity = world.m_7702_(beltLocation);
            if (!(blockEntity instanceof BeltBlockEntity)) {
                return;
            }
            BeltBlockEntity beltBlockEntity = (BeltBlockEntity)blockEntity;
            DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(stack, insertionSide.m_122424_(), false);
            BeltBlockEntity controllerBE = beltBlockEntity.getControllerBE();
            if (controllerBE != null) {
                controllerBE.tick();
            }
            TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            transporter.handleProcessingOnAllItems(tis -> {
                BeltItemElement tracker = new BeltItemElement((TransportedItemStack)tis);
                scene.addElement((PonderElement)tracker);
                scene.linkElement((PonderElement)tracker, link);
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public class SpecialInstructions
    extends PonderSceneBuilder.PonderSpecialInstructions {
        public SpecialInstructions() {
            super((PonderSceneBuilder)CreateSceneBuilder.this);
        }

        public ElementLink<ParrotElement> createBirb(Vec3 location, Supplier<? extends ParrotPose> pose) {
            ElementLinkImpl link = new ElementLinkImpl(ParrotElement.class);
            ParrotElement parrot = ExpandedParrotElement.create((Vec3)location, pose);
            CreateSceneBuilder.this.addInstruction((PonderInstruction)new CreateParrotInstruction(10, Direction.DOWN, parrot));
            CreateSceneBuilder.this.addInstruction(arg_0 -> SpecialInstructions.lambda$createBirb$0(parrot, (ElementLink)link, arg_0));
            return link;
        }

        public ElementLink<ParrotElement> birbOnTurntable(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vec3i)pos), () -> new ParrotSpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vec3i)pos).m_82520_(0.0, 0.5, 0.0), () -> new ParrotSpinOnComponentPose(pos));
        }

        public void conductorBirb(ElementLink<ParrotElement> birb, boolean conductor) {
            CreateSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(birb).map(FunctionalHelper.filterAndCast(ExpandedParrotElement.class)).ifPresent(expandedBirb -> expandedBirb.setConductor(conductor)));
        }

        private static /* synthetic */ void lambda$createBirb$0(ParrotElement parrot, ElementLink link, PonderScene scene) {
            scene.linkElement((PonderElement)parrot, link);
        }

        public static class ParrotSpinOnComponentPose
        extends ParrotPose {
            private final BlockPos componentPos;

            public ParrotSpinOnComponentPose(BlockPos componentPos) {
                this.componentPos = componentPos;
            }

            public void tick(PonderScene scene, Parrot entity, Vec3 location) {
                BlockEntity blockEntity = scene.getWorld().m_7702_(this.componentPos);
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                float rpm = ((KineticBlockEntity)blockEntity).getSpeed();
                entity.f_19859_ = entity.m_146908_();
                entity.m_146922_(entity.m_146908_() + rpm * 0.3f);
            }
        }
    }
}

