/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlock;
import com.simibubi.create.content.redstone.link.RedstoneLinkFrequencySlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private LinkBehaviour link;
    private boolean transmitter;
    public FactoryPanelSupportBehaviour panelSupport;

    public RedstoneLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.panelSupport = new FactoryPanelSupportBehaviour(this, () -> this.link != null && this.link.isListening(), () -> this.receivedSignal > 0, () -> ((RedstoneLinkBlock)AllBlocks.REDSTONE_LINK.get()).updateTransmittedSignal(this.m_58900_(), this.f_58857_, this.f_58858_));
        behaviours.add(this.panelSupport);
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair<ValueBoxTransform, ValueBoxTransform> slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = this.transmitter ? LinkBehaviour.transmitter(this, slots, this::getSignal) : LinkBehaviour.receiver(this, slots, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Transmitter", this.transmitter);
        compound.m_128405_("Receive", this.getReceivedSignal());
        compound.m_128379_("ReceivedChanged", this.receivedSignalChanged);
        compound.m_128405_("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.transmitter = compound.m_128471_("Transmitter");
        super.read(compound, clientPacket);
        this.receivedSignal = compound.m_128451_("Receive");
        this.receivedSignalChanged = compound.m_128471_("ReceivedChanged");
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !this.link.newPosition) {
            this.transmittedSignal = compound.m_128451_("Transmit");
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            LinkBehaviour prevlink = this.link;
            this.removeBehaviour(LinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.REDSTONE_LINK.has(blockState)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.m_61143_((Property)RedstoneLinkBlock.POWERED)) {
            this.receivedSignalChanged = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61122_((Property)RedstoneLinkBlock.POWERED));
        }
        if (this.receivedSignalChanged) {
            Direction attachedFace = ((Direction)blockState.m_61143_((Property)RedstoneLinkBlock.f_52588_)).m_122424_();
            BlockPos attachedPos = this.f_58858_.m_121945_(attachedFace);
            this.f_58857_.m_6289_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_).m_60734_());
            this.f_58857_.m_6289_(attachedPos, this.f_58857_.m_8055_(attachedPos).m_60734_());
            this.receivedSignalChanged = false;
            this.panelSupport.notifyPanels();
        }
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.m_58900_().m_61143_((Property)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

