/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public final class PropertiesParsingHelper {
    public static final Predicate<BlockState> EMPTY_BLOCK_STATE_PREDICATE = state -> false;

    @Nullable
    public static Set<ResourceLocation> parseMatchTiles(Properties properties, String propertyKey, ResourceLocation fileLocation, String packId, @Nullable ResourceRedirectHandler redirectHandler) {
        String matchTilesStr = properties.getProperty(propertyKey);
        if (matchTilesStr == null) {
            return null;
        }
        String[] matchTileStrs = matchTilesStr.trim().split(" ");
        if (matchTileStrs.length != 0) {
            String basePath = FilenameUtils.getPath((String)fileLocation.m_135815_());
            ObjectOpenHashSet set = new ObjectOpenHashSet();
            for (int i = 0; i < matchTileStrs.length; ++i) {
                String matchTileStr = matchTileStrs[i];
                if (matchTileStr.isEmpty()) continue;
                String[] parts = matchTileStr.split(":", 2);
                if (parts.length != 0) {
                    Object path;
                    String namespace;
                    if (parts.length > 1) {
                        namespace = parts[0];
                        path = parts[1];
                    } else {
                        namespace = null;
                        path = parts[0];
                    }
                    if (((String)path).endsWith(".png")) {
                        path = ((String)path).substring(0, ((String)path).length() - 4);
                    }
                    if (namespace == null) {
                        if (((String)path).startsWith("assets/minecraft/")) {
                            path = ((String)path).substring(17);
                        } else if (((String)path).startsWith("./")) {
                            path = basePath + ((String)path).substring(2);
                        } else if (((String)path).startsWith("~/")) {
                            path = "optifine/" + ((String)path).substring(2);
                        } else if (((String)path).startsWith("/")) {
                            path = "optifine/" + ((String)path).substring(1);
                        }
                    }
                    if (((String)path).startsWith("textures/")) {
                        path = ((String)path).substring(9);
                    } else if (((String)path).startsWith("optifine/")) {
                        if (redirectHandler == null) continue;
                        path = redirectHandler.getSourceSpritePath((String)path + ".png");
                        if (namespace == null) {
                            namespace = fileLocation.m_135827_();
                        }
                    } else if (!((String)path).contains("/")) {
                        path = "block/" + (String)path;
                    }
                    if (namespace == null) {
                        namespace = "minecraft";
                    }
                    try {
                        set.add((Object)new ResourceLocation(namespace, (String)path));
                    }
                    catch (ResourceLocationException e) {
                        ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'", (Throwable)e);
                    }
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
            }
            set.trim();
            return set;
        }
        return Collections.emptySet();
    }

    @Nullable
    public static Predicate<BlockState> parseBlockStates(Properties properties, String propertyKey, ResourceLocation fileLocation, String packId) {
        String blockStatesStr = properties.getProperty(propertyKey);
        if (blockStatesStr == null) {
            return null;
        }
        String[] blockStateStrs = blockStatesStr.trim().split(" ");
        if (blockStateStrs.length != 0) {
            ReferenceOpenHashSet blockSet = new ReferenceOpenHashSet();
            Reference2ObjectOpenHashMap propertyMaps = new Reference2ObjectOpenHashMap();
            block2: for (int i = 0; i < blockStateStrs.length; ++i) {
                String blockStateStr = blockStateStrs[i].trim();
                if (blockStateStr.isEmpty()) continue;
                String[] parts = blockStateStr.split(":");
                if (parts.length != 0) {
                    int startIndex;
                    ResourceLocation blockId;
                    try {
                        if (parts.length == 1 || parts[1].contains("=")) {
                            blockId = new ResourceLocation(parts[0]);
                            startIndex = 1;
                        } else {
                            blockId = new ResourceLocation(parts[0], parts[1]);
                            startIndex = 2;
                        }
                    }
                    catch (ResourceLocationException e) {
                        ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'", (Throwable)e);
                        continue;
                    }
                    if (BuiltInRegistries.f_256975_.m_7804_(blockId)) {
                        Block block2 = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
                        if (blockSet.contains((Object)block2)) continue;
                        if (parts.length > startIndex) {
                            Object2ObjectOpenHashMap propertyMap2 = new Object2ObjectOpenHashMap();
                            for (int j = startIndex; j < parts.length; ++j) {
                                String part = parts[j];
                                if (part.isEmpty()) continue;
                                String[] propertyParts = part.split("=", 2);
                                if (propertyParts.length == 2) {
                                    String propertyName = propertyParts[0];
                                    Property property2 = block2.m_49965_().m_61081_(propertyName);
                                    if (property2 != null) {
                                        String propertyValuesStr = propertyParts[1];
                                        String[] propertyValueStrs = propertyValuesStr.split(",");
                                        if (propertyValueStrs.length != 0) {
                                            ObjectOpenHashSet valueSet2 = (ObjectOpenHashSet)propertyMap2.computeIfAbsent((Object)property2, p -> new ObjectOpenHashSet(16, 0.25f));
                                            for (String propertyValueStr : propertyValueStrs) {
                                                Optional optionalValue = property2.m_6215_(propertyValueStr);
                                                if (!optionalValue.isPresent()) {
                                                    ContinuityClient.LOGGER.warn("Invalid block property value '" + propertyValueStr + "' for property '" + propertyName + "' for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
                                                    continue block2;
                                                }
                                                valueSet2.add((Object)((Comparable)optionalValue.get()));
                                            }
                                            continue;
                                        }
                                        ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
                                        continue block2;
                                    }
                                    ContinuityClient.LOGGER.warn("Unknown block property '" + propertyName + "' for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
                                    continue block2;
                                }
                                ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
                                continue block2;
                            }
                            if (propertyMap2.isEmpty()) continue;
                            Object2ObjectOpenHashMap existingPropertyMap = (Object2ObjectOpenHashMap)propertyMaps.get((Object)block2);
                            if (existingPropertyMap == null) {
                                propertyMaps.put((Object)block2, (Object)propertyMap2);
                                continue;
                            }
                            propertyMap2.forEach((property, valueSet) -> {
                                ObjectOpenHashSet existingValueSet = (ObjectOpenHashSet)existingPropertyMap.get(property);
                                if (existingValueSet == null) {
                                    existingPropertyMap.put(property, valueSet);
                                } else {
                                    existingValueSet.addAll((Collection)valueSet);
                                }
                            });
                            continue;
                        }
                        blockSet.add((Object)block2);
                        propertyMaps.remove((Object)block2);
                        continue;
                    }
                    ContinuityClient.LOGGER.warn("Unknown block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
            }
            if (!blockSet.isEmpty() || !propertyMaps.isEmpty()) {
                if (propertyMaps.isEmpty()) {
                    if (blockSet.size() == 1) {
                        Block block3 = ((Block[])blockSet.toArray(Block[]::new))[0];
                        return state -> state.m_60734_() == block3;
                    }
                    blockSet.trim();
                    return state -> blockSet.contains((Object)state.m_60734_());
                }
                Reference2ReferenceOpenHashMap predicateMap = new Reference2ReferenceOpenHashMap();
                blockSet.forEach(block -> predicateMap.put(block, state -> true));
                propertyMaps.forEach((block, propertyMap) -> {
                    Map.Entry[] entryArray;
                    for (Map.Entry entry : entryArray = (Map.Entry[])propertyMap.entrySet().toArray(Map.Entry[]::new)) {
                        ((ObjectOpenHashSet)entry.getValue()).trim();
                    }
                    predicateMap.put(block, state -> {
                        ImmutableMap targetValueMap = state.m_61148_();
                        for (Map.Entry entry : entryArray) {
                            Comparable targetValue = (Comparable)targetValueMap.get(entry.getKey());
                            if (targetValue == null || ((ObjectOpenHashSet)entry.getValue()).contains((Object)targetValue)) continue;
                            return false;
                        }
                        return true;
                    });
                });
                return state -> {
                    Predicate predicate = (Predicate)predicateMap.get((Object)state.m_60734_());
                    return predicate != null && predicate.test(state);
                };
            }
        }
        return EMPTY_BLOCK_STATE_PREDICATE;
    }

    @Nullable
    public static Symmetry parseSymmetry(Properties properties, String propertyKey, ResourceLocation fileLocation, String packId) {
        String symmetryStr = properties.getProperty(propertyKey);
        if (symmetryStr == null) {
            return null;
        }
        try {
            return Symmetry.valueOf(symmetryStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + symmetryStr + "' in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
            return null;
        }
    }

    @Nullable
    public static OrientationMode parseOrientationMode(Properties properties, String propertyKey, ResourceLocation fileLocation, String packId) {
        String orientationModeStr = properties.getProperty(propertyKey);
        if (orientationModeStr == null) {
            return null;
        }
        try {
            return OrientationMode.valueOf(orientationModeStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + orientationModeStr + "' in file '" + String.valueOf(fileLocation) + "' in pack '" + packId + "'");
            return null;
        }
    }

    public static boolean parseOptifineOnly(Properties properties, ResourceLocation fileLocation) {
        if (!fileLocation.m_135827_().equals("minecraft")) {
            return false;
        }
        String optifineOnlyStr = properties.getProperty("optifineOnly");
        if (optifineOnlyStr == null) {
            return false;
        }
        return Boolean.parseBoolean(optifineOnlyStr.trim());
    }
}

