/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.EmissiveSpriteApi;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class EmissiveBakedModel
extends ForwardingBakedModel {
    protected static final RenderMaterial[] EMISSIVE_MATERIALS;
    protected static final RenderMaterial DEFAULT_EMISSIVE_MATERIAL;
    protected static final RenderMaterial CUTOUT_MIPPED_EMISSIVE_MATERIAL;

    public EmissiveBakedModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        EmissiveBlockQuadTransform quadTransform = container.emissiveBlockQuadTransform;
        if (quadTransform.isActive()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        MeshBuilder meshBuilder = container.meshBuilder;
        quadTransform.prepare(meshBuilder.getEmitter(), blockView, state, pos, context, (Boolean)ContinuityConfig.INSTANCE.useManualCulling.get());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        if (quadTransform.didEmit()) {
            meshBuilder.build().outputTo(context.getEmitter());
        }
        quadTransform.reset();
    }

    public void emitItemQuads(ItemStack stack, Supplier<RandomSource> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        EmissiveItemQuadTransform quadTransform = container.emissiveItemQuadTransform;
        if (quadTransform.isActive()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        MeshBuilder meshBuilder = container.meshBuilder;
        quadTransform.prepare(meshBuilder.getEmitter());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
        if (quadTransform.didEmit()) {
            meshBuilder.build().outputTo(context.getEmitter());
        }
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            return super.isVanillaAdapter();
        }
        return false;
    }

    static {
        BlendMode[] blendModes = BlendMode.values();
        EMISSIVE_MATERIALS = new RenderMaterial[blendModes.length];
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        for (BlendMode blendMode : blendModes) {
            EmissiveBakedModel.EMISSIVE_MATERIALS[blendMode.ordinal()] = finder.emissive(true).disableDiffuse(true).ambientOcclusion(TriState.FALSE).blendMode(blendMode).find();
        }
        DEFAULT_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.DEFAULT.ordinal()];
        CUTOUT_MIPPED_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.CUTOUT_MIPPED.ordinal()];
    }

    protected static class EmissiveBlockQuadTransform
    implements RenderContext.QuadTransform {
        protected QuadEmitter emitter;
        protected BlockAndTintGetter blockView;
        protected BlockState state;
        protected BlockPos pos;
        protected RenderContext renderContext;
        protected boolean useManualCulling;
        protected boolean active;
        protected boolean didEmit;
        protected boolean calculateDefaultLayer;
        protected boolean isDefaultLayerSolid;

        protected EmissiveBlockQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.useManualCulling && this.renderContext.isFaceCulled(quad.cullFace())) {
                return false;
            }
            TextureAtlasSprite sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            TextureAtlasSprite emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                RenderMaterial emissiveMaterial;
                this.emitter.copyFrom((QuadView)quad);
                BlendMode blendMode = quad.material().blendMode();
                if (blendMode == BlendMode.DEFAULT) {
                    if (this.calculateDefaultLayer) {
                        this.isDefaultLayerSolid = ItemBlockRenderTypes.m_109282_((BlockState)this.state) == RenderType.m_110451_();
                        this.calculateDefaultLayer = false;
                    }
                    emissiveMaterial = this.isDefaultLayerSolid ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : DEFAULT_EMISSIVE_MATERIAL;
                } else {
                    emissiveMaterial = blendMode == BlendMode.SOLID ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : EMISSIVE_MATERIALS[blendMode.ordinal()];
                }
                this.emitter.material(emissiveMaterial);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
                this.didEmit = true;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean didEmit() {
            return this.didEmit;
        }

        public void prepare(QuadEmitter emitter, BlockAndTintGetter blockView, BlockState state, BlockPos pos, RenderContext renderContext, boolean useManualCulling) {
            this.emitter = emitter;
            this.blockView = blockView;
            this.state = state;
            this.pos = pos;
            this.renderContext = renderContext;
            this.useManualCulling = useManualCulling;
            this.active = true;
            this.didEmit = false;
            this.calculateDefaultLayer = true;
            this.isDefaultLayerSolid = false;
        }

        public void reset() {
            this.emitter = null;
            this.blockView = null;
            this.state = null;
            this.pos = null;
            this.renderContext = null;
            this.useManualCulling = false;
            this.active = false;
        }
    }

    protected static class EmissiveItemQuadTransform
    implements RenderContext.QuadTransform {
        protected QuadEmitter emitter;
        protected boolean active;
        protected boolean didEmit;

        protected EmissiveItemQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            TextureAtlasSprite sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            TextureAtlasSprite emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                this.emitter.copyFrom((QuadView)quad);
                this.emitter.material(DEFAULT_EMISSIVE_MATERIAL);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
                this.didEmit = true;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean didEmit() {
            return this.didEmit;
        }

        public void prepare(QuadEmitter emitter) {
            this.emitter = emitter;
            this.active = true;
            this.didEmit = false;
        }

        public void reset() {
            this.active = false;
            this.emitter = null;
        }
    }
}

