/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.config;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;

public class ConfigFixer {
    public static void replaceConfigHandlers() {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("bugfix.fix_config_crashes.ConfigFixerMixin")) {
            return;
        }
        ModList.get().forEachModContainer((id, container) -> {
            try {
                Optional configOpt = (Optional)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)container, (String)"configHandler");
                if (configOpt.isPresent()) {
                    ObfuscationReflectionHelper.setPrivateValue(ModContainer.class, (Object)container, Optional.of(new LockingConfigHandler((String)id, (Consumer)configOpt.get())), (String)"configHandler");
                }
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Error replacing config handler", (Throwable)e);
            }
        });
    }

    private static class LockingConfigHandler
    implements Consumer<IConfigEvent> {
        private final Consumer<IConfigEvent> actualHandler;
        private final String modId;
        private final Lock lock = new ReentrantLock();

        LockingConfigHandler(String id, Consumer<IConfigEvent> actualHandler) {
            this.modId = id;
            this.actualHandler = actualHandler;
        }

        @Override
        public void accept(IConfigEvent modConfigEvent) {
            block6: {
                try {
                    if (this.lock.tryLock(2L, TimeUnit.SECONDS)) {
                        try {
                            this.actualHandler.accept(modConfigEvent);
                            break block6;
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    ModernFix.LOGGER.error("Failed to post config event for {}, someone else is holding the lock", (Object)this.modId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public String toString() {
            return "LockingConfigHandler{id=" + this.modId + "}";
        }
    }
}

