/*
 * Decompiled with CFR 0.152.
 */
package io.github.steelwoolmc.mixintransmog;

import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import io.github.steelwoolmc.mixintransmog.Constants;
import io.github.steelwoolmc.mixintransmog.DummyMixinTransformationService;
import io.github.steelwoolmc.mixintransmog.GeneratedMixinClassesSecureJar;
import io.github.steelwoolmc.mixintransmog.InstrumentationHack;
import io.github.steelwoolmc.mixintransmog.MixinModlauncherRemapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.MixinLaunchPlugin;
import org.spongepowered.asm.launch.MixinLaunchPluginLegacy;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class MixinTransformationService
implements ITransformationService {
    private static void replaceMixinLaunchPlugin() {
        try {
            ClassLoader classLoader = MixinTransformationService.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Field launcherLaunchPluginsField = Launcher.class.getDeclaredField("launchPlugins");
            launcherLaunchPluginsField.setAccessible(true);
            Field launchPluginHandlerPluginsField = LaunchPluginHandler.class.getDeclaredField("plugins");
            launchPluginHandlerPluginsField.setAccessible(true);
            Map plugins = (Map)launchPluginHandlerPluginsField.get(launcherLaunchPluginsField.get(Launcher.INSTANCE));
            plugins.put("mixin", new MixinLaunchPlugin());
            Constants.LOG.debug("Replaced the mixin launch plugin");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public MixinTransformationService() {
        Constants.LOG.info("Mixin Transmogrifier is definitely up to no good...");
        try {
            InstrumentationHack.inject();
        }
        catch (Throwable t) {
            Constants.LOG.error("Error replacing mixin module source", t);
            throw new RuntimeException(t);
        }
        MixinTransformationService.replaceMixinLaunchPlugin();
        Constants.LOG.info("crimes against java were committed");
    }

    public String name() {
        return "mixin-transmogrifier";
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        Constants.LOG.debug("onLoad called");
        Constants.LOG.debug(String.join((CharSequence)", ", otherServices));
        try {
            Field handlerField = Launcher.class.getDeclaredField("transformationServicesHandler");
            handlerField.setAccessible(true);
            Object handler = handlerField.get(Launcher.INSTANCE);
            Field serviceLookupField = handler.getClass().getDeclaredField("serviceLookup");
            serviceLookupField.setAccessible(true);
            Map serviceLookup = (Map)serviceLookupField.get(handler);
            Constructor ctr = TransformationServiceDecorator.class.getDeclaredConstructor(ITransformationService.class);
            ctr.setAccessible(true);
            TransformationServiceDecorator decorator = (TransformationServiceDecorator)ctr.newInstance(new DummyMixinTransformationService());
            Method onLoad = TransformationServiceDecorator.class.getDeclaredMethod("onLoad", IEnvironment.class, Set.class);
            onLoad.setAccessible(true);
            onLoad.invoke((Object)decorator, env, otherServices);
            serviceLookup.put("mixin", decorator);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void initialize(IEnvironment environment) {
        try {
            Constants.LOG.debug("initialize called");
            Method mixinBootstrapStartMethod = MixinBootstrap.class.getDeclaredMethod("start", new Class[0]);
            mixinBootstrapStartMethod.setAccessible(true);
            Optional plugin = environment.findLaunchPlugin("mixin");
            if (plugin.isEmpty()) {
                throw new Error("Mixin Launch Plugin Service could not be located");
            }
            ILaunchPluginService launchPlugin = (ILaunchPluginService)plugin.get();
            if (!(launchPlugin instanceof MixinLaunchPluginLegacy)) {
                throw new Error("Mixin Launch Plugin Service is present but not compatible");
            }
            Method mixinPluginInitMethod = MixinLaunchPluginLegacy.class.getDeclaredMethod("init", IEnvironment.class, List.class);
            mixinPluginInitMethod.setAccessible(true);
            mixinBootstrapStartMethod.invoke(null, new Object[0]);
            mixinPluginInitMethod.invoke((Object)launchPlugin, environment, List.of());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        if (!FMLEnvironment.production) {
            MixinEnvironment.getDefaultEnvironment().getRemappers().add((IRemapper)new MixinModlauncherRemapper());
        }
        return List.of(new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, List.of(new GeneratedMixinClassesSecureJar())));
    }

    public List<ITransformer> transformers() {
        return List.of();
    }
}

