/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes.polarizing;

import com.drmangotea.tfmg.recipes.jei.PolarizingCategory;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class PolarizingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    private int energy;

    public PolarizingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)TFMGRecipeTypes.POLARIZING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return !inv.m_7983_() && ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    public int getEnergy() {
        return this.energy;
    }

    public Component getDescriptionForAssembly() {
        return CreateLang.translateDirect((String)"recipe.assembly.polarizing", (Object[])new Object[0]);
    }

    public void addRequiredMachines(Set<ItemLike> set) {
        set.add((ItemLike)TFMGBlocks.POLARIZER.get());
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> PolarizingCategory.AssemblyPolarizing::new;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.energy = GsonHelper.m_13824_((JsonObject)json, (String)"energy", (int)250);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        json.addProperty("energy", (Number)this.energy);
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.energy = buffer.readInt();
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeInt(this.energy);
    }
}

