/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.tanks;

import com.drmangotea.tfmg.blocks.tanks.SteelTankBlock;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SteelTankBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    public FluidTank tankInventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    public boolean window = true;
    public int luminosity;
    public int width = 1;
    public int height = 1;
    public int gaugeRotation = 0;
    public int activeHeat;
    public boolean isDistillationTower = false;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;
    public LerpedFloat visualGaugeRotation = LerpedFloat.angular();

    public SteelTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(SteelTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        this.refreshCapability();
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        this.getGaugeRotation();
        this.updateTemperature();
        this.visualGaugeRotation.chase((double)this.gaugeRotation, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.visualGaugeRotation.tickChaser();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    SteelTankBlockEntity tankAt = (SteelTankBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public SteelTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof SteelTankBlockEntity) {
            return (SteelTankBlockEntity)tileEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * SteelTankBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.m_58900_();
        if (SteelTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)SteelTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)SteelTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(SteelTankBlock.SHAPE, (Comparable)((Object)(this.window ? SteelTankBlock.Shape.WINDOW : SteelTankBlock.Shape.PLAIN)));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void toggleWindows() {
        SteelTankBlockEntity te = this.getControllerBE();
        if (te == null) {
            return;
        }
        if (this.isDistillationTower) {
            return;
        }
        te.setWindows(!te.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!SteelTankBlock.isTank(blockState)) continue;
                    SteelTankBlock.Shape shape = SteelTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = SteelTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            SteelTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? SteelTankBlock.Shape.WINDOW_NW : SteelTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? SteelTankBlock.Shape.WINDOW_NE : SteelTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = SteelTankBlock.Shape.WINDOW;
                        }
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(SteelTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasTower = this.isDistillationTower;
        boolean changed = this.evaluate();
        if (wasTower != this.isDistillationTower) {
            if (this.isDistillationTower) {
                this.setWindows(false);
            }
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7918_(xOffset, yOffset, zOffset));
                        if (!(blockEntity instanceof SteelTankBlockEntity)) continue;
                        SteelTankBlockEntity fte = (SteelTankBlockEntity)blockEntity;
                        fte.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.refreshCapability();
        }
    }

    public boolean evaluate() {
        boolean hadController = this.isDistillationTower;
        boolean foundController = false;
        BlockPos pos1 = this.controller == null ? this.m_58899_() : this.controller;
        for (int yOffset = 0; yOffset < this.getControllerBE().height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.getControllerBE().width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.getControllerBE().width; ++zOffset) {
                    BlockPos pos = pos1.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!SteelTankBlock.isTank(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockPos attachedPos = pos.m_121945_(d);
                        BlockState attachedState = this.f_58857_.m_8055_(attachedPos);
                        if (!attachedState.m_60713_((Block)TFMGBlocks.STEEL_DISTILLATION_CONTROLLER.get())) continue;
                        if (!foundController) {
                            foundController = true;
                            continue;
                        }
                        this.f_58857_.m_46961_(attachedPos, true);
                    }
                }
            }
        }
        this.isDistillationTower = foundController;
        return hadController != foundController;
    }

    public void updateTemperature() {
        int prevHeat = this.activeHeat;
        this.activeHeat = 0;
        BlockPos pos1 = this.controller == null ? this.m_58899_() : this.controller;
        SteelTankBlockEntity be = this.getControllerBE() == null ? this : this.getControllerBE();
        for (int xOffset = 0; xOffset < be.width; ++xOffset) {
            for (int zOffset = 0; zOffset < be.width; ++zOffset) {
                BlockState blockState;
                BlockPos pos = pos1.m_7918_(xOffset, -1, zOffset);
                float heat = BoilerHeater.findHeat((Level)this.f_58857_, (BlockPos)pos, (BlockState)(blockState = this.f_58857_.m_8055_(pos)));
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        if (this.activeHeat != prevHeat) {
            this.notifyUpdate();
        }
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : this.tankInventory);
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public SteelTankBlockEntity getOtherFluidTankTileEntity(Direction direction) {
        BlockEntity otherTE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (otherTE instanceof SteelTankBlockEntity) {
            return (SteelTankBlockEntity)otherTE;
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        SteelTankBlockEntity controllerTE = this.getControllerBE();
        if (this.isDistillationTower) {
            return false;
        }
        if (this.getControllerBE() != null && this.getControllerBE().isDistillationTower) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerTE.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        this.isDistillationTower = compound.m_128471_("isDistillationTower");
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * SteelTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(SteelTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
        if (compound.m_128441_("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public void getGaugeRotation() {
        this.gaugeRotation = Math.min(90, this.activeHeat * 15);
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        compound.m_128379_("isDistillationTower", this.isDistillationTower);
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        this.forEachBehaviour(tb -> tb.write(compound, clientPacket));
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public FluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (SteelTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)SteelTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)SteelTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.m_6596_();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return SteelTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return SteelTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

