/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.tanks;

import com.drmangotea.tfmg.blocks.tanks.SteelTankBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SteelFluidTankRenderer
extends SafeBlockEntityRenderer<SteelTankBlockEntity> {
    public SteelFluidTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(SteelTankBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        if (!te.window) {
            if (te.isDistillationTower) {
                this.renderAsDistillationTower(te, partialTicks, ms, buffer, light, overlay);
            }
            return;
        }
        LerpedFloat fluidLevel = te.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)te.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = te.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        float xMin = tankHullWidth;
        float xMax = xMin + (float)te.width - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)te.width - 2.0f * tankHullWidth;
        ms.m_85836_();
        ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false, (boolean)true, (CompoundTag)fluidStack.getTag());
        ms.m_85849_();
    }

    protected void renderAsDistillationTower(SteelTankBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = te.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        ms.m_85836_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((double)((float)te.width / 2.0f), 0.5, (double)((float)te.width / 2.0f));
        float dialPivot = 0.359375f;
        for (Direction d : Iterate.horizontalDirections) {
            ms.m_85836_();
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)TFMGPartialModels.TOWER_GAUGE, (BlockState)blockState).rotateYDegrees(d.m_122435_())).uncenter()).translate((float)te.width / 2.0f - 0.375f, 0.0f, 0.0f)).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (BlockState)blockState).rotateYDegrees(d.m_122435_())).uncenter()).translate((float)te.width / 2.0f - 0.375f, 0.0f, 0.0f)).translate(0.0f, dialPivot, dialPivot)).rotateXDegrees(-te.visualGaugeRotation.getValue(partialTicks))).translate(0.0f, -dialPivot, -dialPivot)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(SteelTankBlockEntity te) {
        return te.isController();
    }
}

