/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace;

import com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace.MoltenMetalBlockEntity;
import com.drmangotea.tfmg.recipes.industrial_blasting.IndustrialBlastingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BlastFurnaceOutputBlockEntity
extends TFMGMachineBlockEntity
implements IHaveGoggleInformation {
    public BlastFurnaceType type;
    public Direction outputFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    public BlockPos mainFloor;
    public int height = 2;
    public int reinforcementHeight = 0;
    public int validHeight = 0;
    public float blastFurnaceLevel = 0.0f;
    public float fuelEfficiency = 1000.0f;
    public float speedModifier = 1.0f;
    public int timer = -1;
    public IndustrialBlastingRecipe recipe;
    public LerpedFloat coalCokeHeight = LerpedFloat.linear();
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public SmartInventory inputInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64);
    public SmartInventory fuelInventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().forbidExtraction().withMaxStackSize(64);
    int debug = 0;

    public BlastFurnaceOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.fuelInventory}));
        this.tank1.getPrimaryHandler().setCapacity(8000);
        this.tank2.getPrimaryHandler().setCapacity(8000);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public void tick() {
        super.tick();
        this.manageMoltenMetal();
        if (this.type == BlastFurnaceType.SMALL) {
            this.blastFurnaceLevel = (float)this.validHeight / 2.0f - 1.0f;
            this.blastFurnaceLevel = (float)Math.min((double)this.blastFurnaceLevel, 2.5);
        }
        if (this.speedModifier != 0.0f) {
            this.speedModifier = this.blastFurnaceLevel / 2.0f;
            this.fuelEfficiency = 400.0f * this.speedModifier;
        } else {
            this.fuelEfficiency = 400.0f;
            this.speedModifier = 1.0f;
        }
        this.outputFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        this.coalCokeHeight.chase((double)(this.fuelInventory.getStackInSlot(0).m_41613_() + this.inputInventory.getStackInSlot(0).m_41613_()), (double)0.1f, LerpedFloat.Chaser.EXP);
        this.coalCokeHeight.tickChaser();
        this.checkType();
        if (this.reinforcementHeight < 2) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.type == BlastFurnaceType.INVALID) {
            return;
        }
        int maxLevelByReinforcements = this.reinforcementHeight * 2;
        this.validHeight = Math.min(maxLevelByReinforcements, this.height);
        if (this.height < 4) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.recipe != null && this.timer == -1 && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity() && this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount() <= this.tank2.getPrimaryHandler().getCapacity() && this.type != BlastFurnaceType.INVALID && !this.fuelInventory.m_7983_()) {
            this.timer = (int)((float)this.recipe.getProcessingDuration() / this.speedModifier);
            this.inputInventory.getStackInSlot(0).m_41764_(this.inputInventory.getStackInSlot(0).m_41613_() - 1);
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInventory);
        if (this.recipe == null || !this.recipe.matches(inventoryIn, this.f_58857_)) {
            Optional recipe = TFMGRecipeTypes.INDUSTRIAL_BLASTING.find(inventoryIn, this.f_58857_);
            if (!recipe.isPresent()) {
                this.timer = -1;
                this.sendData();
            } else {
                this.recipe = (IndustrialBlastingRecipe)((Object)recipe.get());
                this.sendData();
            }
        }
        this.acceptInsertedItems();
        if (this.type != BlastFurnaceType.INVALID && this.timer > 0 && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity() && this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount() <= this.tank2.getPrimaryHandler().getCapacity()) {
            --this.timer;
            int random = Create.RANDOM.nextInt((int)Math.abs(this.fuelEfficiency) + 1);
            if (random == 69) {
                this.fuelInventory.getStackInSlot(0).m_41774_(1);
            }
        }
        if (this.timer == 0) {
            this.process();
            this.timer = -1;
        }
    }

    public void manageMoltenMetal() {
        if (this.timer > 0) {
            BlockPos posToSpawn = this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_();
            if (!this.f_58857_.m_8055_(posToSpawn).m_60713_((Block)TFMGBlocks.MOLTEN_METAL.get())) {
                this.f_58857_.m_7731_(posToSpawn, TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
                this.f_58857_.m_7731_(posToSpawn.m_7494_(), TFMGBlocks.MOLTEN_METAL.getDefaultState(), 3);
            } else {
                ((MoltenMetalBlockEntity)this.f_58857_.m_7702_((BlockPos)posToSpawn)).discardTimer = 40;
                ((MoltenMetalBlockEntity)this.f_58857_.m_7702_((BlockPos)posToSpawn.m_7494_())).discardTimer = 40;
            }
        }
    }

    protected AABB createRenderBoundingBox() {
        int x = this.m_58899_().m_123341_();
        int y = this.m_58899_().m_123342_();
        int z = this.m_58899_().m_123343_();
        return new AABB((double)(x - 10), (double)(y - 10), (double)(z - 10), (double)(x + 10), (double)(y + 10), (double)(z + 10));
    }

    public void process() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.tank1.getPrimaryHandler().setFluid(new FluidStack(((FluidStack)this.recipe.getFluidResults().get(0)).getFluid(), this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(0)).getAmount()));
        this.tank2.getPrimaryHandler().setFluid(new FluidStack(((FluidStack)this.recipe.getFluidResults().get(1)).getFluid(), this.tank2.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.recipe.getFluidResults().get(1)).getAmount()));
    }

    public void acceptInsertedItems() {
        List<ItemEntity> itemsToPick = this.getItemsToPick(this.type);
        for (ItemEntity itemEntity : itemsToPick) {
            ItemStack itemStack = itemEntity.m_32055_();
            if (itemStack.m_150930_((Item)TFMGItems.COAL_COKE_DUST.get())) {
                int freeSpace = this.fuelInventory.getStackInSlot(0).m_41741_() - this.fuelInventory.getStackInSlot(0).m_41613_();
                int coalCokeCount = itemStack.m_41613_();
                if (coalCokeCount > freeSpace) {
                    itemStack.m_41764_(itemStack.m_41613_() - freeSpace);
                    this.fuelInventory.m_6836_(0, new ItemStack((ItemLike)TFMGItems.COAL_COKE_DUST.get(), this.fuelInventory.getStackInSlot(0).m_41613_() + freeSpace));
                    continue;
                }
                this.fuelInventory.m_6836_(0, new ItemStack((ItemLike)TFMGItems.COAL_COKE_DUST.get(), this.fuelInventory.getStackInSlot(0).m_41613_() + itemStack.m_41613_()));
                itemEntity.m_146870_();
                continue;
            }
            if (itemStack.m_41613_() == 1) {
                ItemStack stack2 = itemStack;
                stack2.m_41764_(2);
                itemEntity.m_32045_(stack2);
            }
            int freeSpace2 = this.inputInventory.getStackInSlot(0).m_41741_() - this.inputInventory.getStackInSlot(0).m_41613_();
            int count = itemStack.m_41613_();
            if (!this.inputInventory.m_7983_() && !this.inputInventory.m_8020_(0).m_150930_(itemStack.m_41720_())) continue;
            if (count > freeSpace2) {
                itemStack.m_41764_(itemStack.m_41613_() - freeSpace2);
                this.inputInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.inputInventory.getStackInSlot(0).m_41613_() + freeSpace2));
                continue;
            }
            this.inputInventory.m_6836_(0, new ItemStack((ItemLike)itemStack.m_41720_(), this.inputInventory.getStackInSlot(0).m_41613_() + itemStack.m_41613_()));
            itemEntity.m_146870_();
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.type == BlastFurnaceType.INVALID) {
            CreateLang.translate((String)"goggles.blast_furnace.invalid", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        } else {
            CreateLang.translate((String)"goggles.blast_furnace.stats", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            if (this.timer > 0) {
                CreateLang.translate((String)"goggles.blast_furnace.status.running", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
            } else {
                CreateLang.translate((String)"goggles.blast_furnace.status.off", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
            }
            CreateLang.translate((String)"goggles.blast_furnace.height", (Object[])new Object[]{this.validHeight}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            CreateLang.translate((String)"goggles.misc.storage_info", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
            CreateLang.translate((String)"goggles.blast_furnace.item_count", (Object[])new Object[]{this.inputInventory.getStackInSlot(0).m_41613_()}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            CreateLang.translate((String)"goggles.blast_furnace.fuel_amount", (Object[])new Object[]{this.fuelInventory.getStackInSlot(0).m_41613_()}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            CreateLang.translate((String)"goggles.blast_furnace.nothing_lol", (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.fuelInventory.deserializeNBT(compound.m_128469_("Fuel"));
        this.timer = compound.m_128451_("Timer");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("Fuel", (Tag)this.fuelInventory.serializeNBT());
        compound.m_128405_("Timer", this.timer);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void checkType() {
        this.mainFloor = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        if (!this.isValidBlock(this.mainFloor)) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.reinforcementHeight < 2) {
            this.type = BlastFurnaceType.INVALID;
        }
        if (!this.isAboveClear(this.mainFloor)) {
            this.type = BlastFurnaceType.INVALID;
            return;
        }
        if (this.canBeSmall()) {
            this.type = BlastFurnaceType.SMALL;
        }
        if (!this.canBeSmall()) {
            this.type = BlastFurnaceType.INVALID;
        }
    }

    public boolean isAboveClear(BlockPos pos) {
        return this.f_58857_.m_8055_(pos = pos.m_7494_()).m_60713_(Blocks.f_50016_) || this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.MOLTEN_METAL.get());
    }

    public boolean isAboveValid(BlockPos pos) {
        return this.isAboveValid(pos, false);
    }

    public boolean isAboveValid(BlockPos pos, boolean firstCheck) {
        pos = pos.m_7494_();
        boolean isValid = this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get());
        BlockPos pos1 = pos.m_7494_();
        int height = 2;
        for (int i = 0; i < 8 && this.f_58857_.m_8055_(pos1).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get()); ++i) {
            ++height;
            pos1 = pos1.m_7494_();
        }
        if (height <= this.height || firstCheck) {
            this.height = height;
        }
        return isValid;
    }

    public void isReinforcement(BlockPos pos) {
        this.isReinforcement(pos, false);
    }

    public void isReinforcement(BlockPos pos, boolean firstCheck) {
        BlockPos pos1 = pos;
        int height = 0;
        for (int i = 0; i < 8 && this.f_58857_.m_8055_(pos1).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICK_REINFORCEMENT.get()); ++i) {
            ++height;
            pos1 = pos1.m_7494_();
        }
        if (height <= this.reinforcementHeight || firstCheck) {
            this.reinforcementHeight = height;
        }
    }

    public boolean isValidBlock(BlockPos pos) {
        return this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.FIREPROOF_BRICKS.get());
    }

    public boolean canBeSmall() {
        BlockPos checkedPos = this.m_58899_().m_121945_(this.outputFacing.m_122424_());
        BlockPos mainPos = checkedPos;
        if (!this.isValidBlock(mainPos)) {
            return false;
        }
        if (!this.isAboveClear(mainPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122427_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos, true)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122428_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing.m_122424_());
        if (!this.isValidBlock(checkedPos)) {
            return false;
        }
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        checkedPos = mainPos.m_121945_(this.outputFacing);
        if (!this.isAboveValid(checkedPos)) {
            return false;
        }
        this.isReinforcement(checkedPos.m_121945_(this.outputFacing.m_122428_()), true);
        this.isReinforcement(checkedPos.m_121945_(this.outputFacing.m_122427_()));
        this.isReinforcement(mainPos.m_121945_(this.outputFacing.m_122424_()).m_121945_(this.outputFacing.m_122428_()));
        this.isReinforcement(mainPos.m_121945_(this.outputFacing.m_122424_()).m_121945_(this.outputFacing.m_122427_()));
        return true;
    }

    public List<ItemEntity> getItemsToPick(BlastFurnaceType type) {
        return this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.m_58899_().m_121945_(this.outputFacing.m_122424_()).m_7494_()));
    }

    public static enum BlastFurnaceType {
        SMALL,
        INVALID;

    }
}

