/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.firebox;

import com.drmangotea.tfmg.blocks.machines.firebox.FireboxBlock;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FireboxBlockEntity
extends SmartBlockEntity {
    public static final int MAX_HEAT_CAPACITY = 25000;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory(true);
    public FluidTank exhaustTank = this.createInventory(false);

    public FireboxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.tankInventory, this.exhaustTank}));
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            return;
        }
        if (this.tankInventory.getFluid().getAmount() == 1000 && this.remainingBurnTime <= 3) {
            this.tankInventory.setFluid(FluidStack.EMPTY);
            this.remainingBurnTime = 4000;
            this.activeFuel = FuelType.NORMAL;
            this.spawnParticleBurst(false);
            this.playSound();
        }
        if (this.remainingBurnTime > 0) {
            this.exhaustTank.fill(new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource(), 15), IFluidHandler.FluidAction.EXECUTE);
            --this.remainingBurnTime;
        }
        if (this.exhaustTank.getSpace() == 0) {
            this.remainingBurnTime = 0;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 12500;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        this.tankInventory.writeToNBT(compound.m_128469_("TankContent"));
        this.exhaustTank.writeToNBT(compound.m_128469_("ExhaustContent"));
        compound.m_128405_("fuelLevel", this.activeFuel.ordinal());
        compound.m_128405_("burnTimeRemaining", this.remainingBurnTime);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.m_128451_("fuelLevel")];
        this.remainingBurnTime = compound.m_128451_("burnTimeRemaining");
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
        this.exhaustTank.readFromNBT(compound.m_128469_("ExhaustContent"));
        super.read(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return FireboxBlock.getHeatLevelOf(this.m_58900_());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(FireboxBlock.HEAT_LEVEL, (Comparable)heat));
        this.notifyUpdate();
    }

    protected SmartFluidTank createInventory(final boolean mainTank) {
        return new SmartFluidTank(mainTank ? 1000 : 8000, this::onFluidStackChanged){

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (mainTank) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (mainTank) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!mainTank) {
                    return stack.getFluid() == TFMGFluids.CARBON_DIOXIDE.getSource();
                }
                return stack.getFluid().m_205067_(TFMGTags.TFMGFluidTags.DIESEL.tag) || stack.getFluid().m_205067_(TFMGTags.TFMGFluidTags.LPG.tag) || stack.getFluid().m_205067_(TFMGTags.TFMGFluidTags.KEROSENE.tag);
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
    }

    public boolean isValidBlockAbove() {
        if (this.isVirtual()) {
            return false;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return AllBlocks.BASIN.has(blockState) || blockState.m_60734_() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11705_, SoundSource.BLOCKS, 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.125f, 0.75f - this.f_58857_.f_46441_.m_188501_() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 25000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.f_58857_ == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(4) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        double yMotion = empty ? 0.0625 : r.m_188500_() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.m_188500_() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        RandomSource r = this.f_58857_.f_46441_;
        for (int i = 0; i < 20; ++i) {
            Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_();
            Vec3 v = c.m_82549_(offset.m_82490_(0.5 + r.m_188500_() * 0.125)).m_82520_(0.0, 0.125, 0.0);
            Vec3 m = offset.m_82490_(0.03125);
            this.f_58857_.m_7106_((ParticleOptions)(soulFlame ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

