/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.diesel.engine_expansion;

import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DieselEngineExpansionBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank coolantTank;
    public FluidTank lubricationOilTank;
    public FluidTank airTank = this.createUpgradeTankInventory((Fluid)TFMGFluids.AIR.get());

    public DieselEngineExpansionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.coolantTank = this.createUpgradeTankInventory((Fluid)TFMGFluids.COOLING_FLUID.get());
        this.lubricationOilTank = this.createUpgradeTankInventory((Fluid)TFMGFluids.LUBRICATION_OIL.get());
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.airTank, this.lubricationOilTank, this.coolantTank}));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("LubricationOil", (Tag)this.lubricationOilTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Air", (Tag)this.airTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Coolant", (Tag)this.coolantTank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lubricationOilTank.readFromNBT(compound.m_128469_("LubricationOil"));
        this.airTank.readFromNBT(compound.m_128469_("Air"));
        this.coolantTank.readFromNBT(compound.m_128469_("Coolant"));
        super.read(compound, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
    }

    protected SmartFluidTank createUpgradeTankInventory(final Fluid validFluid) {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_(validFluid);
            }
        };
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"goggles.diesel_engine_info", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }
}

