/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.engines.diesel;

import com.drmangotea.tfmg.blocks.engines.diesel.DieselEngineBlock;
import com.drmangotea.tfmg.blocks.engines.diesel.engine_expansion.DieselEngineExpansionBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DieselEngineBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<PoweredShaftBlockEntity> target = new WeakReference<Object>(null);
    public FluidTank fuelTank;
    protected FluidTank exhaustTank;
    protected FluidTank airTank;
    private int consumptionTimer = 0;
    public float engineStrength = 0.0f;
    private Couple<FluidTank> tanks;
    public BlockPos expansionPos;
    public DieselEngineExpansionBlockEntity expansionBE;
    protected LazyOptional<CombinedTankWrapper> fluidCapability;
    float prevAngle = 0.0f;

    public DieselEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fuelTank = this.createInventory(TFMGTags.TFMGFluidTags.DIESEL.tag, false);
        this.exhaustTank = this.createInventory((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource(), true);
        this.airTank = this.createInventory((Fluid)TFMGFluids.AIR.getSource(), false);
        this.tanks = Couple.create((Object)this.fuelTank, (Object)this.exhaustTank);
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.airTank, this.exhaustTank}));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    private void onDirectionChanged() {
    }

    public void tick() {
        int conveyedSpeedLevel;
        PoweredShaftBlockEntity shaft;
        super.tick();
        if (this.m_58900_().m_61143_(DieselEngineBlock.FACE) == AttachFace.WALL) {
            this.expansionPos = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
        }
        if (this.m_58900_().m_61143_(DieselEngineBlock.FACE) == AttachFace.CEILING) {
            this.expansionPos = this.m_58899_().m_7494_();
        }
        if (this.m_58900_().m_61143_(DieselEngineBlock.FACE) == AttachFace.FLOOR) {
            this.expansionPos = this.m_58899_().m_7495_();
        }
        if (this.expansionBE == null) {
            this.expansionBE = this.f_58857_.m_7702_(this.expansionPos) instanceof DieselEngineExpansionBlockEntity ? (DieselEngineExpansionBlockEntity)this.f_58857_.m_7702_(this.expansionPos) : null;
        }
        if (this.expansionBE != null && !(this.expansionBE instanceof DieselEngineExpansionBlockEntity)) {
            this.expansionBE = null;
        }
        if ((shaft = this.getShaft()) == null) {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.m_58899_().m_121996_((Vec3i)this.f_58858_).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = DieselEngineBlock.getFacing(this.m_58900_());
            if (this.f_58857_.m_46749_(this.f_58858_.m_121945_(facing.m_122424_()))) {
                shaft.update(this.f_58858_, 0, 0.0f);
            }
            return;
        }
        boolean verticalTarget = false;
        BlockState shaftState = shaft.m_58900_();
        Direction.Axis targetAxis = Direction.Axis.X;
        Block block = shaftState.m_60734_();
        if (block instanceof IRotate) {
            IRotate ir = (IRotate)block;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        verticalTarget = targetAxis == Direction.Axis.Y;
        BlockState blockState = this.m_58900_();
        if (!TFMGBlocks.DIESEL_ENGINE.has(blockState)) {
            return;
        }
        Direction facing = DieselEngineBlock.getFacing(blockState);
        if (facing.m_122434_() == Direction.Axis.Y) {
            facing = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (!this.f_58857_.f_46443_ && this.getShaft() != null) {
            this.engineProcess(targetAxis, verticalTarget);
        }
        if (this.f_58857_.f_46443_) {
            this.makeSound(targetAxis, verticalTarget);
        }
        int n = this.engineStrength == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection((float)1.0f, (Direction)facing) * 2);
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            conveyedSpeedLevel *= -1;
        }
    }

    private void makeSound(Direction.Axis targetAxis, boolean verticalTarget) {
        float angle;
        Float targetAngle = this.getTargetAngle();
        PoweredShaftBlockEntity ste = (PoweredShaftBlockEntity)this.target.get();
        if (ste == null) {
            return;
        }
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (((FluidTank)this.tanks.get(true)).isEmpty() || ((FluidTank)this.tanks.get(true)).isEmpty()) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (this.expansionBE != null) {
            if (this.airTank.isEmpty() && this.expansionBE.airTank.isEmpty()) {
                this.engineStrength = 0.0f;
                shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
                return;
            }
        } else if (this.airTank.isEmpty()) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (((FluidTank)this.tanks.get(false)).getFluidAmount() + 5 > 1000) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (targetAngle == null) {
            return;
        }
        angle += (angle = AngleHelper.deg((double)targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
        angle %= 360.0f;
        if (shaft == null || shaft.getSpeed() == 0.0f) {
            return;
        }
        if (!(!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f)) {
            this.prevAngle = angle;
            return;
        }
        if (!(!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f)) {
            this.prevAngle = angle;
            return;
        }
        TFMGSoundEvents.DIESEL_ENGINE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.4f, 1.0f, false);
        this.prevAngle = angle;
    }

    public int getConveyedSpeedLevel(float strength, Direction.Axis targetAxis, boolean verticalTarget) {
        int conveyedSpeedLevel;
        Direction facing = SteamEngineBlock.getFacing((BlockState)this.m_58900_());
        PoweredShaftBlockEntity shaft = this.getShaft();
        int n = this.engineStrength == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection((float)1.0f, (Direction)facing) * 2);
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            conveyedSpeedLevel *= -1;
        }
        return conveyedSpeedLevel;
    }

    private void engineProcess(Direction.Axis targetAxis, boolean verticalTarget) {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (((FluidTank)this.tanks.get(true)).isEmpty() || ((FluidTank)this.tanks.get(true)).isEmpty()) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (this.expansionBE != null) {
            if (this.airTank.isEmpty() && this.expansionBE.airTank.isEmpty()) {
                this.engineStrength = 0.0f;
                shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
                return;
            }
        } else if (this.airTank.isEmpty()) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (((FluidTank)this.tanks.get(false)).getFluidAmount() + 5 > 1000) {
            this.engineStrength = 0.0f;
            shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
            return;
        }
        if (this.consumptionTimer >= 5) {
            int fuelModifier = 0;
            if (this.expansionBE != null && !this.expansionBE.coolantTank.isEmpty()) {
                fuelModifier = 1;
            }
            this.fuelTank.setFluid(new FluidStack((Fluid)TFMGFluids.DIESEL.getSource(), this.fuelTank.getFluidAmount() - (2 - fuelModifier)));
        }
        if (!this.airTank.isEmpty()) {
            this.airTank.setFluid(new FluidStack((Fluid)TFMGFluids.AIR.getSource(), this.airTank.getFluidAmount() - 5));
        } else {
            this.expansionBE.airTank.setFluid(new FluidStack((Fluid)TFMGFluids.AIR.getSource(), this.expansionBE.airTank.getFluidAmount() - 5));
        }
        this.exhaustTank.fill(new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource(), 3), IFluidHandler.FluidAction.EXECUTE);
        int strengthModifier = 0;
        if (this.expansionBE != null) {
            if (!this.expansionBE.coolantTank.isEmpty()) {
                strengthModifier += 3;
                if (this.consumptionTimer > 5) {
                    this.expansionBE.coolantTank.setFluid(new FluidStack((Fluid)TFMGFluids.COOLING_FLUID.getSource(), this.expansionBE.coolantTank.getFluidAmount() - 1));
                }
            }
            if (!this.expansionBE.lubricationOilTank.isEmpty()) {
                strengthModifier += 5;
                if (this.consumptionTimer > 5) {
                    this.expansionBE.lubricationOilTank.setFluid(new FluidStack((Fluid)TFMGFluids.LUBRICATION_OIL.getSource(), this.expansionBE.lubricationOilTank.getFluidAmount() - 1));
                }
            }
        }
        if (!this.f_58857_.m_8055_(this.expansionPos).m_60713_((Block)TFMGBlocks.DIESEL_ENGINE_EXPANSION.get())) {
            strengthModifier = 0;
        }
        if (this.consumptionTimer > 5) {
            this.consumptionTimer = 0;
        }
        ++this.consumptionTimer;
        this.engineStrength = 40 + strengthModifier;
        shaft.update(this.f_58858_, this.getConveyedSpeedLevel(this.engineStrength, targetAxis, verticalTarget), this.engineStrength);
        this.sendData();
        this.m_6596_();
    }

    public void remove() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.f_58858_);
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = (PoweredShaftBlockEntity)this.target.get();
        if (shaft == null || shaft.m_58901_() || !shaft.canBePoweredBy(this.f_58858_)) {
            PoweredShaftBlockEntity ps;
            Direction facing;
            BlockEntity anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing = DieselEngineBlock.getFacing(this.m_58900_()), 2))) instanceof PoweredShaftBlockEntity && (ps = (PoweredShaftBlockEntity)anyShaftAt).canBePoweredBy(this.f_58858_)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        float angle = 0.0f;
        BlockState blockState = this.m_58900_();
        if (!TFMGBlocks.DIESEL_ENGINE.has(blockState)) {
            return null;
        }
        Direction facing = SteamEngineBlock.getFacing((BlockState)blockState);
        PoweredShaftBlockEntity shaft = this.getShaft();
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        if (shaft == null) {
            return null;
        }
        axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)shaft, (BlockPos)shaft.m_58899_(), (Direction.Axis)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.m_122479_() && facingAxis == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Fuel", (Tag)this.fuelTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Air", (Tag)this.airTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Exhaust", (Tag)this.exhaustTank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.fuelTank.readFromNBT(compound.m_128469_("Fuel"));
        this.airTank.readFromNBT(compound.m_128469_("Air"));
        this.exhaustTank.readFromNBT(compound.m_128469_("Exhaust"));
        super.read(compound, clientPacket);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void notifyUpdate() {
        super.notifyUpdate();
    }

    public Couple<FluidTank> getTanks() {
        return this.tanks;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"goggles.diesel_engine.info", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.sendData();
    }

    protected SmartFluidTank createInventory(final Fluid validFluid, final boolean extractionAllowed) {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_(validFluid);
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }
        };
    }

    protected SmartFluidTank createInventory(final TagKey<Fluid> validFluid, final boolean extractionAllowed) {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_205067_(validFluid);
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }
        };
    }
}

