/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.segmented_display;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.segmented_display.SegmentedDisplayRenderer;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SegmentedDisplayBlockEntity
extends ElectricBlockEntity {
    private static final Couple<String> EMPTY = Couple.create((Object)"", (Object)"");
    private Optional<DynamicComponent> customText;
    private Couple<String> displayedStrings;
    public List<Integer> segmentsToRender = new ArrayList<Integer>();
    public List<Integer> segmentsToRender2 = new ArrayList<Integer>();
    public DyeColor color;
    private int partIndex;

    public SegmentedDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.customText = Optional.empty();
        this.color = DyeColor.LIME;
    }

    public void setColor(DyeColor color) {
        if (color == DyeColor.BLACK || color == DyeColor.LIGHT_GRAY || color == DyeColor.GRAY) {
            return;
        }
        this.color = color;
        this.notifyUpdate();
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.useEnergy(2);
        this.getOrCreateElectricNetwork().requestEnergy(this);
        if (this.voltage < 10 || this.energy.getEnergyStored() == 0) {
            this.segmentsToRender = new ArrayList<Integer>();
            this.segmentsToRender2 = new ArrayList<Integer>();
        } else {
            this.segmentsToRender = this.getSegments();
        }
    }

    public void clearCustomText() {
        this.partIndex = 0;
        this.customText = Optional.empty();
    }

    public List<Integer> getSegments() {
        List<Integer> segments = SegmentedDisplayRenderer.SYMBOLS_TO_SEGMENTS.get(((String)this.getDisplayedStrings().get(true)).toLowerCase());
        List<Integer> segments2 = SegmentedDisplayRenderer.SYMBOLS_TO_SEGMENTS.get(((String)this.getDisplayedStrings().get(false)).toLowerCase());
        if (segments2 == null) {
            segments2 = new ArrayList<Integer>();
        }
        if (segments == null) {
            segments = new ArrayList<Integer>();
        }
        ArrayList<Integer> segments3 = new ArrayList<Integer>();
        for (int segment : segments2) {
            segments3.add(segment + 10);
        }
        this.segmentsToRender2 = segments3;
        return segments;
    }

    @Override
    public int FECapacity() {
        return 150;
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public void initialize() {
        if (this.f_58857_.f_46443_) {
            this.updateDisplayedStrings();
        }
    }

    public void displayCustomText(String tagElement, int partPositionInRow) {
        if (tagElement == null) {
            return;
        }
        if (this.customText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.f_58857_, this.f_58858_, tagElement);
        this.customText = Optional.of(component);
        this.partIndex = partPositionInRow;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
        this.notifyUpdate();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction != this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    public void updateDisplayedStrings() {
        this.customText.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create((Object)this.charOrEmpty((String)fullText, this.partIndex * 2), (Object)this.charOrEmpty((String)fullText, this.partIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create((Object)"0", (Object)"0");
        });
    }

    public MutableComponent getFullText() {
        return this.customText.map(DynamicComponent::get).orElse(Component.m_237113_((String)""));
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.color = (DyeColor)NBTHelper.readEnum((CompoundTag)nbt, (String)"color", DyeColor.class);
        if (nbt.m_128441_("CustomText")) {
            DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
            component.read(this.f_58857_, this.f_58858_, nbt);
            if (component.isValid()) {
                this.customText = Optional.of(component);
                this.partIndex = nbt.m_128451_("CustomTextIndex");
            } else {
                this.customText = Optional.empty();
                this.partIndex = 0;
            }
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        NBTHelper.writeEnum((CompoundTag)nbt, (String)"color", (Enum)this.color);
        if (this.customText.isPresent()) {
            nbt.m_128405_("CustomTextIndex", this.partIndex);
            this.customText.get().write(nbt);
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }
}

