/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.polarizer;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.recipes.polarizing.PolarizingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class PolarizerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(1);
    Optional<PolarizingRecipe> recipe;
    public int timer = 0;

    public PolarizerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.POLARIZER.get());
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.voltage < 200) {
            this.timer = -1;
            return;
        }
        if (this.inventory.m_8020_(0).m_41619_()) {
            this.timer = -1;
            return;
        }
        this.recipe = this.getRecipe(this.inventory.m_8020_(0));
        if (this.recipe.isEmpty()) {
            this.timer = -1;
            return;
        }
        if (!((Ingredient)this.recipe.get().m_7527_().get(0)).test(this.inventory.m_8020_(0))) {
            this.timer = -1;
            return;
        }
        if (this.energy.getEnergyStored() != 0) {
            this.useEnergy(this.recipe.get().getEnergy());
            if (!this.inventory.m_7983_()) {
                if (this.timer < this.recipe.get().getProcessingDuration()) {
                    ++this.timer;
                } else {
                    this.timer = -1;
                    this.inventory.setStackInSlot(0, this.recipe.get().m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
                    TFMGUtils.spawnElectricParticles(this.f_58857_, this.m_58899_());
                    this.sendStuff();
                }
            }
        } else {
            this.timer = -1;
        }
    }

    public Optional<PolarizingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, TFMGRecipeTypes.POLARIZING.getType(), PolarizingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        this.inventory.m_6836_(0, item);
        return TFMGRecipeTypes.POLARIZING.find(this.inventory, this.f_58857_);
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    public void destroy() {
        super.destroy();
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.inventory.getStackInSlot(0));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemCapability.cast() : super.getCapability(cap, side);
    }

    public boolean playerInteract(Player player, InteractionHand hand) {
        if (this.inventory.m_7983_()) {
            ItemStack stack = player.m_21120_(hand).m_41777_();
            stack.m_41764_(1);
            this.inventory.setStackInSlot(0, stack);
            this.sendStuff();
            player.m_21120_(hand).m_41774_(1);
            return true;
        }
        if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, this.inventory.m_8020_(0));
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            this.sendStuff();
            return true;
        }
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.energy.getEnergyStored() == 0) {
            CreateLang.translate((String)"goggles.electric_machine.no_power", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        if (this.voltage < 200) {
            CreateLang.translate((String)"goggles.electricity.insufficient_voltage", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            return true;
        }
        if (this.timer > 0 && this.recipe.isPresent()) {
            CreateLang.translate((String)"goggles.blast_furnace.status.running", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            tooltip.add((Component)this.percent(this.timer, this.recipe.get()).m_130940_(ChatFormatting.GREEN));
        } else {
            CreateLang.translate((String)"goggles.blast_furnace.status.off", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    public void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        super.read(tag, clientPacket);
    }

    private MutableComponent percent(int timer, PolarizingRecipe recipe) {
        int percent = Math.round((float)timer / (float)recipe.getProcessingDuration() * 100.0f);
        return CreateLang.builder().text(" ").text(percent + "%").component();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
    }
}

