/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.large_generator;

import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.RotorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RotorRenderer
extends KineticBlockEntityRenderer<RotorBlockEntity> {
    public RotorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(RotorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.m_58900_();
        float speed = be.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = be.angle + speed * partialTicks;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        this.renderFrame(be, ms, light, blockState, angle, vb);
        this.renderFlywheel(be, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(RotorBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBuffers.block((BlockState)blockState);
        RotorRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)RotorRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    private void renderFrame(RotorBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        ms.m_85836_();
        Direction direction = null;
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        if (axis == Direction.Axis.X) {
            direction = Direction.WEST;
        }
        if (axis == Direction.Axis.Y) {
            direction = Direction.UP;
        }
        if (axis == Direction.Axis.Z) {
            direction = Direction.NORTH;
        }
        ms.m_85849_();
    }

    protected BlockState getRenderedBlockState(RotorBlockEntity be) {
        return RotorRenderer.shaft((Direction.Axis)RotorRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

