/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.fuse_block;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.blocks.electricity.fuse_block.FuseBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FuseBlockEntity
extends VoltageAlteringBlockEntity {
    public FuseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void blowFuse() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 2.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)FuseBlock.LOADED, (Comparable)Boolean.valueOf(false)), 2);
        TFMGUtils.spawnElectricParticles(this.f_58857_, this.m_58899_());
    }

    public void insertFuse() {
        IElectric be;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)FuseBlock.LOADED, (Comparable)Boolean.valueOf(true)), 2);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            be.needsVoltageUpdate();
        }
    }

    public boolean hasFuse() {
        return (Boolean)this.m_58900_().m_61143_((Property)FuseBlock.LOADED);
    }

    @Override
    public void lazyTick() {
        IElectric be;
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_()) && this.hasFuse()) {
            ElectricalNetwork.sendEnergy(this, be);
        }
    }

    @Override
    public void setVoltage(int value, boolean update) {
        IElectric be;
        super.setVoltage(value, update);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            be.getOrCreateElectricNetwork().updateNetworkVoltage();
        }
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    @Override
    public int getOutputVoltage() {
        return this.hasFuse() ? this.getVoltage() : 0;
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.FUSE_BLOCK.get());
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
    }
}

