/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.energy_components.resistors;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ResistorBlockEntity
extends VoltageAlteringBlockEntity {
    protected ScrollValueBehaviour outputVoltage;

    public ResistorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getOutputVoltage() {
        return this.outputVoltage.value;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.outputVoltage = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"resistor.allowed_voltage", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ResistorValueBox());
        this.outputVoltage.between(0, max);
        this.outputVoltage.value = 50;
        this.outputVoltage.withCallback(i -> this.setVoltage(this.voltageGeneration(), true));
        behaviours.add((BlockEntityBehaviour)this.outputVoltage);
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    @Override
    public void lazyTick() {
        IElectric be;
        super.lazyTick();
        this.getOrCreateElectricNetwork().requestEnergy(this);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            ElectricalNetwork.sendEnergy(this, be);
        }
    }

    public int voltageOutput() {
        return Math.min(this.outputVoltage.getValue(), this.getVoltage());
    }

    @Override
    public void setVoltage(int value, boolean update) {
        IElectric be;
        super.setVoltage(value, update);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).hasElectricitySlot(facing.m_122424_())) {
            be.getOrCreateElectricNetwork().updateNetworkVoltage();
        }
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.RESISTOR.get());
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
    }

    class ResistorValueBox
    extends ValueBoxTransform.Sided {
        ResistorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZ(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (direction != Direction.UP) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

