/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.cable_blocks;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireConnection;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager;
import com.drmangotea.tfmg.blocks.electricity.energy_components.resistors.ResistorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CableHubBlockEntity
extends ElectricBlockEntity {
    boolean signalChanged;
    public boolean hasSignal;

    public CableHubBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onPlaced() {
        this.networkUpdate = true;
        if (!this.hasSignal) {
            this.connectNeighbors();
        }
        this.setVoltage(this.voltageGeneration());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
    }

    public void neighbourChanged() {
        boolean powered;
        if (!this.m_58898_()) {
            return;
        }
        boolean bl = powered = this.f_58857_.m_277086_(this.f_58858_) > 0;
        if (powered != this.hasSignal) {
            this.signalChanged = true;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    protected void analogSignalChanged(int newSignal) {
        boolean bl = this.hasSignal = newSignal > 0;
        if (newSignal == 0) {
            for (Direction direction : Direction.values()) {
                BlockPos pos;
                BlockEntity blockEntity;
                if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(pos = this.m_58899_().m_121945_(direction))) instanceof IElectric)) continue;
                IElectric be = (IElectric)blockEntity;
                if (be instanceof CableHubBlockEntity) {
                    CableHubBlockEntity be1 = (CableHubBlockEntity)be;
                    if (be1.hasSignal || be1 == this) continue;
                }
                if (!be.hasElectricitySlot(direction.m_122424_())) continue;
                be.addConnection(WireManager.Conductor.COPPER, this.m_58899_(), false, true);
                be.sendStuff();
                this.addConnection(WireManager.Conductor.COPPER, pos, false, true);
                this.sendData();
                this.m_6596_();
                be.makeControllerAndSpread();
            }
        } else {
            this.getOrCreateElectricNetwork().remove(this);
            ElectricNetworkManager.networks.get(this.f_58857_).remove(this.getId());
            this.needsNetworkUpdate();
            this.needsVoltageUpdate();
            this.onVoltageChanged();
            for (WireConnection connection : this.wireConnections) {
                BlockPos pos = connection.point1 == this.m_58899_() ? connection.point2 : connection.point1;
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (!(blockEntity instanceof IElectric)) continue;
                IElectric be = (IElectric)blockEntity;
                be.makeControllerAndSpread();
                be.getOrCreateElectricNetwork().updateNetworkVoltage();
                be.getOrCreateElectricNetwork().updateVoltageFromNetwork();
                if (!(be instanceof ResistorBlockEntity)) continue;
                be.getOrCreateElectricNetwork().voltage = 0;
            }
        }
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.CABLE_HUB.get());
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return !this.hasSignal;
    }
}

