/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.concrete.formwork;

import com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FormWorkBlockEntity
extends TFMGMachineBlockEntity {
    public boolean east = true;
    public boolean west = true;
    public boolean north = true;
    public boolean south = true;
    public boolean bottom = true;
    public int timer = -1;
    protected FluidTank tankInventory;
    public LerpedFloat fluidLevel = LerpedFloat.linear();

    public FormWorkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.tank1.forbidInsertion();
        this.tank2.forbidExtraction();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource());
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        };
    }

    public void tick() {
        if (this.tankInventory.getFluidAmount() == this.tankInventory.getCapacity()) {
            if (this.timer == -1) {
                this.timer = 4320;
            } else {
                --this.timer;
                if (this.timer == 0) {
                    this.f_58857_.m_7731_(this.m_58899_(), TFMGBlocks.CONCRETE.getDefaultState(), 3);
                }
            }
        } else {
            this.timer = -1;
        }
        super.tick();
        this.fluidLevel.chase((double)this.tankInventory.getFluidAmount(), (double)0.3f, LerpedFloat.Chaser.EXP);
        this.fluidLevel.tickChaser();
        BlockEntity blockEntityBelow = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        BlockEntity blockEntityNorth = this.f_58857_.m_7702_(this.m_58899_().m_122012_());
        BlockEntity blockEntityWest = this.f_58857_.m_7702_(this.m_58899_().m_122024_());
        BlockEntity blockEntityEast = this.f_58857_.m_7702_(this.m_58899_().m_122029_());
        BlockEntity blockEntitySouth = this.f_58857_.m_7702_(this.m_58899_().m_122019_());
        this.bottom = !(blockEntityBelow instanceof FormWorkBlockEntity);
        this.east = !(blockEntityEast instanceof FormWorkBlockEntity);
        this.west = !(blockEntityWest instanceof FormWorkBlockEntity);
        this.north = !(blockEntityNorth instanceof FormWorkBlockEntity);
        this.south = !(blockEntitySouth instanceof FormWorkBlockEntity);
        for (int x = 0; x < 30; ++x) {
            for (int i = 0; i < 5; ++i) {
                FluidTank checkedTank;
                BlockEntity CheckedBE = null;
                if (i == 0) {
                    CheckedBE = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
                }
                if (i == 1) {
                    CheckedBE = this.f_58857_.m_7702_(this.m_58899_().m_122029_());
                }
                if (i == 2) {
                    CheckedBE = this.f_58857_.m_7702_(this.m_58899_().m_122024_());
                }
                if (i == 3) {
                    CheckedBE = this.f_58857_.m_7702_(this.m_58899_().m_122012_());
                }
                if (i == 4) {
                    CheckedBE = this.f_58857_.m_7702_(this.m_58899_().m_122019_());
                }
                if (!(CheckedBE instanceof FormWorkBlockEntity) || ((FormWorkBlockEntity)CheckedBE).tankInventory.getFluidAmount() > this.tankInventory.getFluidAmount() && i != 0 || (checkedTank = ((FormWorkBlockEntity)CheckedBE).tankInventory).getFluidAmount() >= 1000) continue;
                if (checkedTank.getFluidAmount() >= 995 && this.tankInventory.getFluidAmount() > 0) {
                    checkedTank.setFluid(new FluidStack((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource(), checkedTank.getFluidAmount() + 1));
                }
                int reducedAmount = this.tankInventory.getFluidAmount() / 8;
                if (this.tankInventory.getFluidAmount() != 0) {
                    reducedAmount = 1;
                }
                int newFluidAmount = checkedTank.getFluidAmount() + reducedAmount;
                int toRemove = reducedAmount;
                if (newFluidAmount > 1000) continue;
                checkedTank.setFluid(new FluidStack((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource(), newFluidAmount));
                this.tankInventory.drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.bottom = compound.m_128471_("Bottom");
        this.east = compound.m_128471_("East");
        this.west = compound.m_128471_("West");
        this.north = compound.m_128471_("North");
        this.south = compound.m_128471_("South");
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.timer);
        compound.m_128379_("Bottom", this.bottom);
        compound.m_128379_("East", this.east);
        compound.m_128379_("West", this.west);
        compound.m_128379_("North", this.north);
        compound.m_128379_("South", this.south);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }
}

