/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.reflection;

import cpw.mods.modlauncher.api.INameMappingService;
import java.util.WeakHashMap;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtil {
    private static final String REMAPPED_ON_ENTITY_COLLISION = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"m_7892_");
    private static final WeakHashMap<Class<?>, Boolean> CACHED_IS_ENTITY_TOUCHABLE = new WeakHashMap();

    public static boolean hasMethodOverride(Class<?> clazz, Class<?> superclass, boolean fallbackResult, String methodName, Class<?> ... methodArgs) {
        while (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                clazz.getDeclaredMethod(methodName, methodArgs);
                return true;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (NoClassDefFoundError error) {
                Logger logger = LogManager.getLogger((String)"Canary Class Analysis");
                logger.warn("Canary Class Analysis Error: Class " + clazz.getName() + " cannot be analysed, because getting declared methods crashes with NoClassDefFoundError: " + error.getMessage() + ". This is usually caused by modded entities declaring methods that have a return type or parameter type that is annotated with @OnlyIn(value=Dist.CLIENT). Loading the type is not possible, because it only exists in the CLIENT environment. The recommended fix is to annotate the method with this argument or return type with the same annotation. Canary handles this error by assuming the class cannot be included in some optimizations.");
                return fallbackResult;
            }
            catch (Throwable e) {
                String crashedClass = clazz.getName();
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Canary Class Analysis");
                CrashReportCategory crashReportSection = crashReport.m_127514_(e.getClass().toString() + " when getting declared methods.");
                crashReportSection.m_128159_("Analyzed class", (Object)crashedClass);
                crashReportSection.m_128159_("Analyzed method name", (Object)methodName);
                crashReportSection.m_128159_("Analyzed method args", methodArgs);
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public static boolean isBlockStateEntityTouchable(BlockState operand) {
        Class<?> blockClazz = operand.m_60734_().getClass();
        Boolean result = CACHED_IS_ENTITY_TOUCHABLE.get(blockClazz);
        if (result != null) {
            return result;
        }
        boolean res = ReflectionUtil.hasMethodOverride(blockClazz, BlockBehaviour.class, true, REMAPPED_ON_ENTITY_COLLISION, BlockState.class, Level.class, BlockPos.class, Entity.class);
        CACHED_IS_ENTITY_TOUCHABLE.put(blockClazz, res);
        return res;
    }
}

