/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ToolSwapperUpgradeWrapper
extends UpgradeWrapperBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeItem>
implements IBlockClickResponseUpgrade,
IAttackEntityResponseUpgrade,
IBlockToolSwapUpgrade,
IEntityToolSwapUpgrade {
    private static final LoadingCache<ItemStack, Boolean> isToolCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ItemStack, Boolean>(){

        public Boolean load(ItemStack key) {
            return ToolSwapperUpgradeWrapper.canPerformToolAction(key);
        }
    });
    private final FilterLogic filterLogic;
    @Nullable
    private ResourceLocation toolCacheFor = null;
    private final Queue<ItemStack> toolCache = new LinkedList<ItemStack>();
    private Block lastMinedBlock = Blocks.f_50016_;
    private static final Set<ToolAction> BLOCK_MODIFICATION_ACTIONS = Set.of(ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.SHOVEL_FLATTEN, ToolActions.SHEARS_CARVE, ToolActions.SHEARS_HARVEST);

    protected ToolSwapperUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((Integer)Config.SERVER.toolSwapperUpgrade.filterSlots.get()).intValue());
    }

    @Override
    public boolean onBlockClick(Player player, BlockPos pos) {
        ToolSwapMode toolSwapMode = this.getToolSwapMode();
        if (player.m_7500_() || player.m_5833_() || toolSwapMode == ToolSwapMode.NO_SWAP) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41720_() instanceof BackpackItem || toolSwapMode == ToolSwapMode.ONLY_TOOLS && this.isSword(mainHandItem, player) || !this.isSword(mainHandItem, player) && this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        double mainToolSpeed = 0.0;
        if (this.isGoodAtBreakingBlock(state, mainHandItem)) {
            if (this.lastMinedBlock == block) {
                return true;
            }
            mainToolSpeed = mainHandItem.m_41691_(state);
        }
        this.lastMinedBlock = block;
        return this.tryToSwapTool(player, state, mainToolSpeed, mainHandItem);
    }

    private boolean tryToSwapTool(Player player, BlockState state, double mainHandItemSpeed, ItemStack mainHandItem) {
        AtomicReference<ItemStack> selectedTool = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        AtomicInteger selectedSlot = new AtomicInteger(-1);
        AtomicDouble bestSpeed = new AtomicDouble(mainHandItemSpeed);
        InventoryHandler backpackInventory = this.storageWrapper.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            if (this.isAllowedAndGoodAtBreakingBlock(state, (ItemStack)stack)) {
                float destroySpeed = stack.m_41691_(state);
                if (bestSpeed.get() < (double)destroySpeed) {
                    bestSpeed.set((double)destroySpeed);
                    selectedSlot.set((int)slot);
                    selectedTool.set((ItemStack)stack);
                }
            }
        });
        ItemStack tool = selectedTool.get();
        if (!tool.m_41619_() && this.hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool((IItemHandlerSimpleInserter)backpackInventory, mainHandItem, tool, selectedSlot.get())) {
            player.m_21008_(InteractionHand.MAIN_HAND, backpackInventory.extractItem(selectedSlot.get(), 1, false));
            backpackInventory.insertItem(mainHandItem, false);
            return true;
        }
        return false;
    }

    private boolean hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool(IItemHandlerSimpleInserter backpackInventory, ItemStack mainHandItem, ItemStack tool, int selectedSlot) {
        return backpackInventory.insertItem(mainHandItem, true).m_41619_() || tool.m_41613_() == 1 && backpackInventory.isItemValid(selectedSlot, mainHandItem);
    }

    private boolean isAllowedAndGoodAtBreakingBlock(BlockState state, ItemStack stack) {
        return this.filterLogic.matchesFilter(stack) && this.isGoodAtBreakingBlock(state, stack);
    }

    private boolean isGoodAtBreakingBlock(BlockState state, ItemStack stack) {
        return stack.m_41735_(state) && (double)stack.m_41691_(state) > 1.5;
    }

    @Override
    public boolean onAttackEntity(Player player) {
        if (!this.shouldSwapWeapon()) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (this.isSword(mainHandItem, player)) {
            return true;
        }
        if (mainHandItem.m_41720_() instanceof BackpackItem || this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        return this.tryToSwapInWeapon(player, mainHandItem);
    }

    private boolean isNotTool(ItemStack stack) {
        return (Boolean)isToolCache.getUnchecked((Object)stack) == false;
    }

    private static boolean canPerformToolAction(ItemStack stack) {
        return ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_AXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_HOE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_PICKAXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_SHOVEL_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_SHEARS_ACTIONS);
    }

    private static boolean canPerformAnyAction(ItemStack stack, Set<ToolAction> toolActions) {
        for (ToolAction toolAction : toolActions) {
            if (!stack.canPerformAction(toolAction)) continue;
            return true;
        }
        return false;
    }

    private boolean isSword(ItemStack stack, Player player) {
        if (SwordRegistry.isSword(stack)) {
            return true;
        }
        AttributeInstance attackDamage = player.m_21051_(Attributes.f_22281_);
        if (!stack.m_41619_() && stack.canPerformAction(ToolActions.SWORD_SWEEP)) {
            return attackDamage != null && attackDamage.m_22111_(Item.f_41374_) != null;
        }
        return false;
    }

    private boolean tryToSwapInWeapon(Player player, ItemStack mainHandItem) {
        AtomicReference<ItemStack> bestAxe = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        AtomicDouble bestAxeDamage = new AtomicDouble(0.0);
        AtomicReference<ItemStack> bestSword = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        AtomicDouble bestSwordDamage = new AtomicDouble(0.0);
        this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, mainHandItem);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (this.filterLogic.matchesFilter(stack)) {
                this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, (ItemStack)stack);
            }
        });
        if (!bestSword.get().m_41619_()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestSword.get());
        }
        if (!bestAxe.get().m_41619_()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestAxe.get());
        }
        return false;
    }

    private void updateBestWeapons(AtomicReference<ItemStack> bestAxe, AtomicDouble bestAxeDamage, AtomicReference<ItemStack> bestSword, AtomicDouble bestSwordDamage, ItemStack stack) {
        AttributeInstance attribute = new AttributeInstance(Attributes.f_22281_, a -> {});
        Multimap attributeModifiers = stack.m_41638_(EquipmentSlot.MAINHAND);
        if (!attributeModifiers.containsKey((Object)Attributes.f_22281_)) {
            return;
        }
        attributeModifiers.get((Object)Attributes.f_22281_).forEach(m -> {
            attribute.m_22130_(m);
            attribute.m_22118_(m);
        });
        double damageValue = attribute.m_22135_();
        if (stack.canPerformAction(ToolActions.AXE_DIG)) {
            if (damageValue > bestAxeDamage.get()) {
                bestAxe.set(stack);
                bestAxeDamage.set(damageValue);
            }
        } else if ((SwordRegistry.isSword(stack) || stack.canPerformAction(ToolActions.SWORD_SWEEP)) && damageValue > bestSwordDamage.get()) {
            bestSword.set(stack);
            bestSwordDamage.set(damageValue);
        }
    }

    private boolean swapWeapon(Player player, ItemStack mainHandItem, IItemHandlerSimpleInserter backpackInventory, ItemStack sword) {
        if (sword == mainHandItem) {
            return true;
        }
        ItemStack swordCopy = sword.m_41777_();
        swordCopy.m_41764_(1);
        InventoryHelper.extractFromInventory((ItemStack)swordCopy, (IItemHandler)backpackInventory, (boolean)false);
        if (backpackInventory.insertItem(mainHandItem, true).m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, swordCopy);
            backpackInventory.insertItem(mainHandItem, false);
            return true;
        }
        backpackInventory.insertItem(swordCopy, false);
        return false;
    }

    public boolean hideSettingsTab() {
        return !((ToolSwapperUpgradeItem)this.upgradeItem).hasSettingsTab();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldSwapWeapon() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldSwapWeapon").orElse(true);
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldSwapWeapon", (boolean)shouldSwapWeapon);
        this.save();
    }

    public ToolSwapMode getToolSwapMode() {
        return NBTHelper.getEnumConstant((ItemStack)this.upgrade, (String)"toolSwapMode", ToolSwapMode::fromName).orElse(ToolSwapMode.ANY);
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        NBTHelper.setEnumConstant((ItemStack)this.upgrade, (String)"toolSwapMode", (Enum)toolSwapMode);
        this.save();
    }

    @Override
    public boolean onEntityInteract(Level world, Entity entity, Player player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnEntity((ItemStack)stack, entity), ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
    }

    private boolean itemWorksOnEntity(ItemStack stack, Entity entity) {
        if (this.isShearableEntity(entity, stack) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForEntity(stack, entity);
    }

    @Override
    public boolean onBlockInteract(Level world, BlockPos pos, BlockState blockState, Player player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnBlock(world, pos, blockState, player, (ItemStack)stack), ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()));
    }

    private boolean tryToSwapTool(Player player, Predicate<ItemStack> isToolValid, @Nullable ResourceLocation targetRegistryName) {
        ItemStack tool;
        ItemStack mainHandStack = player.m_21205_();
        if (mainHandStack.m_41720_() instanceof BackpackItem) {
            return false;
        }
        if (this.toolCacheFor == null || !this.toolCacheFor.equals((Object)targetRegistryName)) {
            this.toolCache.clear();
            this.toolCacheFor = targetRegistryName;
        }
        boolean itemInHandIsValid = isToolValid.test(mainHandStack);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (itemInHandIsValid && this.toolCache.stream().noneMatch(st -> ItemStack.m_41656_((ItemStack)st, (ItemStack)mainHandStack))) {
            this.toolCache.offer(mainHandStack);
        }
        if ((tool = this.findToolToSwap((IItemHandlerSimpleInserter)backpackInventory, isToolValid)).m_41619_()) {
            return false;
        }
        if ((tool = tool.m_41777_().m_41620_(1)).m_41613_() == 1 || backpackInventory.insertItem(mainHandStack, true).m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, InventoryHelper.extractFromInventory((ItemStack)tool, (IItemHandler)backpackInventory, (boolean)false));
            backpackInventory.insertItem(mainHandStack, false);
            this.toolCache.offer(tool);
        }
        return true;
    }

    private ItemStack findToolToSwap(IItemHandlerSimpleInserter backpackInventory, Predicate<ItemStack> isValidTool) {
        HashSet<ItemStack> alreadyGivenBefore = new HashSet<ItemStack>();
        AtomicReference<ItemStack> toolFound = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            if (!this.hasEquivalentItem((Collection<ItemStack>)this.toolCache, (ItemStack)stack)) {
                if (isValidTool.test((ItemStack)stack)) {
                    toolFound.set((ItemStack)stack);
                }
            } else {
                alreadyGivenBefore.add((ItemStack)stack);
            }
        }, () -> !((ItemStack)toolFound.get()).m_41619_());
        if (toolFound.get().m_41619_() && !alreadyGivenBefore.isEmpty()) {
            while (this.toolCache.peek() != null) {
                ItemStack itemStack = this.toolCache.poll();
                if (!this.hasEquivalentItem(alreadyGivenBefore, itemStack)) continue;
                toolFound.set(itemStack);
                break;
            }
        }
        return toolFound.get();
    }

    private boolean hasEquivalentItem(Collection<ItemStack> alreadyGivenBefore, ItemStack stack) {
        for (ItemStack givenTool : alreadyGivenBefore) {
            if (!ItemStack.m_41656_((ItemStack)givenTool, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean itemWorksOnBlock(Level level, BlockPos pos, BlockState blockState, Player player, ItemStack stack) {
        for (ToolAction action : BLOCK_MODIFICATION_ACTIONS) {
            if (!stack.canPerformAction(action) || blockState.getToolModifiedState(new UseOnContext(level, player, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, true)), action, true) == null) continue;
            return true;
        }
        Block block = blockState.m_60734_();
        if (this.isShearInteractionBlock(level, pos, stack, block) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForBlock(stack, block, level, blockState, pos);
    }

    private boolean isShearsItem(ItemStack stack) {
        return stack.m_41720_() instanceof ShearsItem || stack.m_204117_(Tags.Items.SHEARS);
    }

    private boolean isShearInteractionBlock(Level world, BlockPos pos, ItemStack stack, Block block) {
        IForgeShearable shearable;
        return block instanceof IForgeShearable && (shearable = (IForgeShearable)block).isShearable(stack, world, pos) || block instanceof BeehiveBlock;
    }

    private boolean isShearableEntity(Entity entity, ItemStack stack) {
        IForgeShearable shearable;
        return entity instanceof IForgeShearable && (shearable = (IForgeShearable)entity).isShearable(stack, entity.m_9236_(), entity.m_20183_());
    }

    @Override
    public boolean canProcessBlockInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }

    @Override
    public boolean canProcessEntityInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }
}

